///////////////////////////////////////////////////////////////////////////////
//                                              SAMPLE CODE
//
// FileName: ACDFMdl1.cpp
//
// ClassName: ACompDocFwkModel
//
// Description: Compound Document Framework (SimpleServer) Model
//              This is a simple sample to demonstrate how to create a basic
//              server application. The model class inherits from the IModel
//              class.
//              The server has a data string as its model data. This data
//              is set to "Hello World" when the model is constructed.
//              
///////////////////////////////////////////////////////////////////////////////
#include <ireslib.hpp>
#include "acdfres1.h"
#include "ACDFMdl1.hpp"
#include "ACDFVw1.hpp"

#include <ibasstrm.hpp>
#include <fstream.h>
#include <istatnry.hpp>
#include <iexcept.hpp>
#include <icconst.h>
#include <iframe.hpp>

TypeExtensionMacro(ACompDocFwkModel) // Type extention for streaming

ACompDocFwkModel::ACompDocFwkModel() 
// Default Constructor
{       IFUNCTRACE_DEVELOP();

     setString(IApplication::current().userResourceLibrary().loadString(STR_HELLO));
}

ACompDocFwkModel::~ACompDocFwkModel()
// Default Destructor
{       IFUNCTRACE_DEVELOP(); }

ACompDocFwkModel::ACompDocFwkModel( const ACompDocFwkModel& other ) :
            IModel( other ) // force assert
// Copy Constructor
{       IFUNCTRACE_DEVELOP(); }

IString ACompDocFwkModel::getString() const
// Implement method for reading member data
{       IFUNCTRACE_DEVELOP();
    return fDataString;
}

Boolean ACompDocFwkModel::setString( const IString& str )
// Implement method for setting member data
{       IFUNCTRACE_DEVELOP();
    fDataString = str;
    return true;
}

IBaseStream& ACompDocFwkModel::operator>>=(IBaseStream& toWhere) const
// Stream member data out
{       IFUNCTRACE_DEVELOP();
    writeVersion(toWhere, kOriginalVersion);
    IModel::operator>>=( toWhere );
    fDataString >>= toWhere;
    return toWhere;
}


IBaseStream& ACompDocFwkModel::operator<<=(IBaseStream& fromWhere)
// Stream member data in
{       IFUNCTRACE_DEVELOP();
    switch (readVersion(fromWhere))
    {
        case kOriginalVersion:
            IModel::operator<<=( fromWhere );
            fDataString <<= fromWhere;
            break;
        default:
            ITHROWLIBRARYERROR(IC_STREAM_VERSION_UNSUPPORTED, 
                              IBaseErrorInfo::invalidRequest,
                              IException::recoverable);
    }
    return fromWhere;
}

// IComponent Stationery class is created using the model, view

IComponentStationeryFor<ACompDocFwkModel,ACompDocFwkView> CompDocFwkStationery;

int main( int argc, char* argv[] )
{
    int ireturn;
    try
    {
        // Stationery run will eventually call the IApplication::current().run()
        ireturn =  CompDocFwkStationery.run( argc, argv );
    }

    catch (IException& exc)
    {
        ofstream  errorFile("errormsg.log",ios::app);
        const IExceptionLocation *excLocate = exc.locationAtIndex(0);

        errorFile << "Exception on exit " << exc.text() << endl;
        errorFile << "File : " << excLocate->fileName() << endl;
        errorFile << "Function : " << excLocate->functionName() << endl;
        errorFile << "Line : " << excLocate->lineNumber() << endl;

        cout << "Exception on exit " << exc.text() << endl;
        cout << "File : " << excLocate->fileName() << endl;
        cout << "Function : " << excLocate->functionName() << endl;
        cout << "Line : " << excLocate->lineNumber() << endl;
    }
    return ireturn;
}
    
