///////////////////////////////////////////////////////////////////////////////
//                      SAMPLE CODE
//
// FileName: ACDFMdl1.hpp
//
// ClassName: ACompDocFwkModel
//
// Description: Compound Document Framework (Simple Server) Model Header file
//              This is a simple sample to demonstrate how to create a basic
//              server application. The model class inherits from the IModel
//              class.
//              The server has a data string as its model data. This data
//              is set to "Hello World" when the model is constructed.
//              
///////////////////////////////////////////////////////////////////////////////
#ifndef _COMPDOCFWK_MODEL_
#define _COMPDOCFWK_MODEL_

#ifdef IC_TRACE_DEVELOP
    #include <itrace.hpp>
#else
    #define IFUNCTRACE_DEVELOP()
    #define ITRACE_DEVELOP(x)
#endif

#include <istring.hpp>
#include <imodel.hpp>

class ACompDocFwkModel : public IModel  // Server inherits from the IModel
{
public:
    TypeExtensionDeclarationsMacro(ACompDocFwkModel) // Type Extention for Streaming

                            ACompDocFwkModel();
    virtual                 ~ACompDocFwkModel();
    
    virtual IString         getString() const;
    virtual Boolean         setString(const IString&);

    virtual IBaseStream&    operator>>=( IBaseStream& towhere ) const;
    virtual IBaseStream&    operator<<=( IBaseStream& fromwhere );

protected:
                            ACompDocFwkModel( const ACompDocFwkModel&);

private:
    enum                    { kOriginalVersion };
    ACompDocFwkModel&       operator=(const ACompDocFwkModel&);

    IString                 fDataString;
};

#endif
    
