///////////////////////////////////////////////////////////////////////////////
//                                              SAMPLE CODE
//
// FileName: ACDFVw1.cpp
//
// ClassName: ACompDocFwkView
//
// Description: Compound Document Framework (SimpleServer) View
//              This is a simple sample to demonstrate how to create a basic
//              server application. The view class inherits from the IView
//              class.
//              The server has an entry field on the screen. This data
//              is set to "Hello World" when the view is redrawn (drawContents)
//              The view does not 'set' the model data only 'get'.
//              
///////////////////////////////////////////////////////////////////////////////
#include "ACDFMdl1.hpp"
#include "ACDFVw1.hpp"
#include "ACDFRes1.h"

#include <iMetaTyp.hpp>
#include <iframe.hpp>
#include <igstring.hpp>
#include <igrect.hpp>
#include <igrafctx.hpp>
#include <assert.h>
#include <iguibndl.hpp> // must be include after windows.h

ACompDocFwkView::ACompDocFwkView(IGUIBundle& bundle ) :
    IView(bundle),
    fDataEntryField (ID_ENTRY, this, this)  // Constructor for the entry field
// Constructor
{       IFUNCTRACE_DEVELOP();
    bundle.frameWindow().setIcon(IC_ACDF1);   // Set the window icon
}

ACompDocFwkView::~ACompDocFwkView()
// Destructor
{       IFUNCTRACE_DEVELOP(); }

ACompDocFwkModel* ACompDocFwkView::getModelPointer() const
// Get the pointer to the model 
{       IFUNCTRACE_DEVELOP();
    ACompDocFwkModel* fOurModel = NULL;
    ::dynamicCastTo( fOurModel,model() ); // Downcasts the Model pointer
    return fOurModel;                     
}

void ACompDocFwkView::initialize()
// Intialize code e.g build menus
{       IFUNCTRACE_DEVELOP();
    IView::initialize();
    bundle().objectView().setBackgroundColor(IColor(64,128,128)); // Set the color to green

    fDataEntryField.moveSizeTo(IRectangle(IPoint(10,10), IPoint(100,40)));
    ACompDocFwkModel* fOurModel = getModelPointer();
    assert(fOurModel != NULL);

    fDataEntryField.setText(fOurModel->getString());

}

void ACompDocFwkView::drawContents( IPresSpaceHandle& hdl,
                const IRectangle& invalidArea,
                Boolean metaFile )
//  We can override "drawContents" if we want to optimize our drawing
//  or do things differently when rendering to a meta-file (where controls
//  won't be displayed).
{       IFUNCTRACE_DEVELOP();
    ACompDocFwkModel* fOurModel = getModelPointer();
    assert(fOurModel != NULL);
     
    if (metaFile)
    {
      //Place the embedded inactive image here!!!
       IGString myText(fOurModel->getString(),IPoint(20,10));
       IGRectangle myRect(IRectangle(IPoint(10,10), IPoint(150,40)));
       IGraphicContext ctxt ( hdl );
       ctxt.setFillColor(IColor::white);
       myRect.drawOn(ctxt);
       myText.drawOn(ctxt);
    }
}
