///////////////////////////////////////////////////////////////////////////////
//                      SAMPLE CODE
//
// FileName: ACDFVw1.hpp
//
// ClassName: ACompDocFwkView
//
// Description: Compound Document Framework (SimpleServer) View Header File
//              This is a simple sample to demonstrate how to create a basic
//              server application. The view class inherits from the IView
//              class.
//              The server has an entry field on the screen. This data
//              is set to "Hello World" when the view is redrawn (drawContents)
//              The view does not 'set' the model data only 'get'.
//              
///////////////////////////////////////////////////////////////////////////////
#ifndef _COMPDOCFWK_VIEW_
#define _COMPDOCFWK_VIEW_

#ifdef IC_TRACE_DEVELOP
    #include <itrace.hpp>
#else
    #define IFUNCTRACE_DEVELOP()
    #define ITRACE_DEVELOP(x)
#endif

#include <iview.hpp>

#include <ientryfd.hpp>

class ACompDocFwkModel;

class ACompDocFwkView : public IView  //Inherit from the View class
{
public:
                                ACompDocFwkView(IGUIBundle& );
    virtual                     ~ACompDocFwkView();

    virtual void                initialize();

    // This is convenience function that downcast the model
    virtual ACompDocFwkModel*   getModelPointer() const;

    virtual void                drawContents( IPresSpaceHandle&,
                                            const IRectangle& invalidArea,
                                            Boolean metaFile );

protected:
                                ACompDocFwkView(const ACompDocFwkView&);

private:
    ACompDocFwkView&            operator=( const ACompDocFwkView& );

    IEntryField                 fDataEntryField;
};
#endif
    
    
