///////////////////////////////////////////////////////////////////////////////
//                                              SAMPLE CODE
//
// FileName: ACDFMdl2.cpp
//
// ClassName: ACompDocFwkModel
//
// Description: Compound Document Framework (SimpleServer) Model
//              This sample is to illustrates the use of notification in the
//              server application.When the model data is changed, a notification
//              event will be sent to the view object, in this example the notification ID
//              is "Data String Changed".
//              There are 'get' and 'set' methods for all of the model data. 
//              When the model data is streamed out the pointer to 'MyObject'
//              is 'flatten'ed, and when the streamed in the pointer is 'resurrect'ed
///////////////////////////////////////////////////////////////////////////////

#include "ACDFMdl2.hpp"
#include "ACDFVw2.hpp"
#include "ACDFMy2.hpp"
#include "ACDFSt2.hpp"
#include "ACDFRes2.h"

#include <fstream.h>
#include <ibasstrm.hpp>
#include <ireslib.hpp>
#include <iexcept.hpp>
#include <icconst.h>
#include <assert.h>
#include <iframe.hpp>

TypeExtensionMacro(ACompDocFwkModel)

const INotificationId ACompDocFwkModel::kDataPointerChange = "Pointer Changed ";
const INotificationId ACompDocFwkModel::kDataStringChange1 = "String Changed 1";
const INotificationId ACompDocFwkModel::kDataStringChange2 = "String Changed 2";

ACompDocFwkModel::ACompDocFwkModel() 
// Default Constructor
{       IFUNCTRACE_DEVELOP();
    fDataString1 = IApplication::current().userResourceLibrary().loadString(STR_HELLO_1);
    fDataString2 = IApplication::current().userResourceLibrary().loadString(STR_HELLO_2);
    fPointerMyString = new ACompDocFwkMyObject;
    fPointerMyString->setMyString(fDataString1);
 }

ACompDocFwkModel::~ACompDocFwkModel()
// Default Destructor
{       IFUNCTRACE_DEVELOP();
    delete fPointerMyString;
}

ACompDocFwkModel::ACompDocFwkModel( const ACompDocFwkModel& other ) :
            IModel( other ) // force assert
// Copy Constructor
{       IFUNCTRACE_DEVELOP();}

IString ACompDocFwkModel::getString1() const
// Implement method for reading member data

{       IFUNCTRACE_DEVELOP();
    return fDataString1;
}

Boolean ACompDocFwkModel::setString1( const IString& str )
// Implement method for setting member data
{       IFUNCTRACE_DEVELOP();
    fDataString1 = str;
    notifyOfChange(INotificationEvent(kDataStringChange1, notifier()));
    return true;
}
IString ACompDocFwkModel::getString2() const
// Implement method for reading member data

{       IFUNCTRACE_DEVELOP();
    return fDataString2;
}

Boolean ACompDocFwkModel::setString2( const IString& str )
// Implement method for setting member data
{       IFUNCTRACE_DEVELOP();
    fDataString2 = str;
    notifyOfChange(INotificationEvent(kDataStringChange2, notifier()));
    return true;
}

IString ACompDocFwkModel::getPointerMyString() const
// Implement method for reading member data

{       IFUNCTRACE_DEVELOP();
    return fPointerMyString->getMyString();
}

Boolean ACompDocFwkModel::setPointerMyString( const IString& str )
// Implement method for setting member data
{       IFUNCTRACE_DEVELOP();

    fPointerMyString->setMyString(str);
    notifyOfChange(INotificationEvent(kDataPointerChange, notifier()));
    return true;
} 

IBaseStream& ACompDocFwkModel::operator>>=(IBaseStream& toWhere) const
// Stream member data out
{       IFUNCTRACE_DEVELOP();
    writeVersion(toWhere, kOriginalVersion);
    IModel::operator>>=( toWhere );
    fDataString1 >>= toWhere;
    fDataString2 >>= toWhere;
    ::flatten (fPointerMyString, toWhere);
    return toWhere;
}


IBaseStream& ACompDocFwkModel::operator<<=(IBaseStream& fromWhere)
// Stream member data in
{       IFUNCTRACE_DEVELOP();
    switch (readVersion(fromWhere))
    {
        case kOriginalVersion:
            IModel::operator<<=( fromWhere );
            fDataString1 <<= fromWhere;
            fDataString2 <<= fromWhere;
            ::resurrect(fPointerMyString, fromWhere);
            break;
        default:
            ITHROWLIBRARYERROR(IC_STREAM_VERSION_UNSUPPORTED, 
                               IBaseErrorInfo::invalidRequest,
                               IException::recoverable);
    }
    return fromWhere;
}
// IComponent Stationery class is created using the model, view

ACompDocFwkMyStationery CompDocFwkStationery;

int main( int argc, char* argv[] )
{
    int ireturn;
    try
    {
        // Stationery run will eventually call the IApplication::current().run()
        ireturn =  CompDocFwkStationery.run( argc, argv );
    }

    catch (IException& exc)
    {
        ofstream  errorFile("errormsg.log",ios::app);
        const IExceptionLocation *excLocate = exc.locationAtIndex(0);

        errorFile << "Exception on exit " << exc.text() << endl;
        errorFile << "File : " << excLocate->fileName() << endl;
        errorFile << "Function : " << excLocate->functionName() << endl;
        errorFile << "Line : " << excLocate->lineNumber() << endl;

        cout << "Exception on exit " << exc.text() << endl;
        cout << "File : " << excLocate->fileName() << endl;
        cout << "Function : " << excLocate->functionName() << endl;
        cout << "Line : " << excLocate->lineNumber() << endl;
    }
    return ireturn;
}
    
