///////////////////////////////////////////////////////////////////////////////
//                      SAMPLE CODE
//
// FileName: ACDFMdl2.hpp
//
// ClassName: ACompDocFwkModel
//
// Description: Compound Document Framework (SimpleServer) Model header file
//              This sample is to illustrates the use of notification in the
//              server application.When the model data is changed, a notification
//              event will be sent to the view object, in this example the notification ID
//              is "Data String Changed".
//              There are 'get' and 'set' methods for all of the model data. 
//              When the model data is streamed out the pointer to 'MyObject'
//              is 'flatten'ed, and when the streamed in the pointer is 'resurrect'ed
///////////////////////////////////////////////////////////////////////////////
#ifndef _COMPDOCFWK_MODEL_
#define _COMPDOCFWK_MODEL_

#ifdef IC_TRACE_DEVELOP
    #include <itrace.hpp>
#else
    #define IFUNCTRACE_DEVELOP()
    #define ITRACE_DEVELOP(x)
#endif

#include <inotifev.hpp>
#include <istring.hpp>
#include <iModel.hpp>

class ACompDocFwkMyObject;

class ACompDocFwkModel : public IModel  // Inherit from the IModel class
{
public:

    TypeExtensionDeclarationsMacro(ACompDocFwkModel)

    static const INotificationId kDataPointerChange;
    static const INotificationId kDataStringChange1;
    static const INotificationId kDataStringChange2;

                            ACompDocFwkModel();
    virtual                 ~ACompDocFwkModel();

    virtual IString         getString1() const;
    virtual IBoolean        setString1(const IString&);

    virtual IString         getString2() const;
    virtual IBoolean        setString2(const IString&);

    virtual IString         getPointerMyString() const;
    virtual Boolean         setPointerMyString(const IString&);

    virtual IBaseStream&    operator>>=( IBaseStream& towhere ) const;
    virtual IBaseStream&    operator<<=( IBaseStream& fromwhere );

protected:
                            ACompDocFwkModel( const ACompDocFwkModel&);

private:
    enum                    { kOriginalVersion };
    ACompDocFwkModel&       operator=(const ACompDocFwkModel&);

    IString                 fDataString1;
    IString                 fDataString2;
    ACompDocFwkMyObject*    fPointerMyString;
};

#endif
