///////////////////////////////////////////////////////////////////////////////
//                             SAMPLE CODE
//
// FileName: ACDFMy2.cpp
//
// ClassName: ACompDocFwkMyObject
//
// Description: Compound Document Framework (SimpleServer) 
//
///////////////////////////////////////////////////////////////////////////////
#include <ibasstrm.hpp>
#include <iMetaTyp.hpp>
#include <iexcept.hpp>
#include <icconst.h>
#include <assert.h>

#include "ACDFMy2.hpp"

TypeExtensionMacro(ACompDocFwkMyObject)

ACompDocFwkMyObject::ACompDocFwkMyObject() : fMyString()
// Default Constructor
{   IFUNCTRACE_DEVELOP();}

ACompDocFwkMyObject::ACompDocFwkMyObject(IString str) : fMyString(str)
// Constructor initilize string
{   IFUNCTRACE_DEVELOP();}

ACompDocFwkMyObject::~ACompDocFwkMyObject()
// Default Destructor
{   IFUNCTRACE_DEVELOP();}

ACompDocFwkMyObject::ACompDocFwkMyObject( const ACompDocFwkMyObject& other ) :
          fMyString( other.fMyString )
// Copy Constructor
{   IFUNCTRACE_DEVELOP();}

IString ACompDocFwkMyObject::getMyString() const
// Implement method for reading member data

{   IFUNCTRACE_DEVELOP();
    return fMyString;
}

IBoolean ACompDocFwkMyObject::setMyString( const IString& str )
// Implement method for setting member data
{   IFUNCTRACE_DEVELOP();
    fMyString = str;
    return true;
}

IBaseStream& ACompDocFwkMyObject::operator>>=(IBaseStream& toWhere) const
// Stream member data out
{   IFUNCTRACE_DEVELOP();
    writeVersion(toWhere,kOriginalVersion);
    fMyString >>= toWhere;
    return toWhere;
}


IBaseStream& ACompDocFwkMyObject::operator<<=(IBaseStream& fromWhere)
// Stream member data in
{   IFUNCTRACE_DEVELOP();
    switch (readVersion(fromWhere))
    {
        case kOriginalVersion:
            fMyString <<= fromWhere;
            break;
        default:
            ITHROWLIBRARYERROR(IC_STREAM_VERSION_UNSUPPORTED, 
                               IBaseErrorInfo::invalidRequest,
                               IException::recoverable);
    }
    return fromWhere;
}

     
