///////////////////////////////////////////////////////////////////////////////
//                    	SAMPLE CODE
//
// FileName: ACDFVw2.hpp
//
// ClassName: ACompDocFwkView
//
// Description: Compound Document Framework (SimpleServer) View
//              This sample is to illustrates the use of notification and the use of
//              keyboard, mouse and command handlers in the server application. When 
//              a notification is recieved from the model, if the handleNotification method
//              was NOT overridden the drawContents would have been called and the notification ID
//              not checked. 
//              In this case the handleNotification method was overridden as a result different data
//              is set depending on the NotificationId
//              The view contains 2 entry fields to allow the user to change the model data
//              by entering the new data and hitting either newline or enter. Using the keyboard
//              handler to trap these events.
//              Doubleclick on either of the entry fields to change the string in MyObject 
//              in the model, using the mouse handler trap this event.
//              The pushbutton and the menu option perform the same function which is
//              to update both the strings in the model.
///////////////////////////////////////////////////////////////////////////////
#ifndef _COMPDOCFWK_VIEW_
#define _COMPDOCFWK_VIEW_

#ifdef IC_TRACE_DEVELOP
    #include <itrace.hpp>
#else
    #define IFUNCTRACE_DEVELOP()
    #define ITRACE_DEVELOP(x)
#endif

#include <iview.hpp>

#include <ipushbut.hpp>
#include <ientryfd.hpp>
#include <istattxt.hpp>

#include <icmdhdr.hpp>
#include <ikeyhdr.hpp>
#include <imoushdr.hpp>

class ACompDocFwkModel;

class ACompDocFwkView : public IView    //Inherits from the IView class
{
public:
                                ACompDocFwkView(IGUIBundle& );
    virtual                     ~ACompDocFwkView();

    virtual void                initialize();

    // This is convenience function that downcast the model
    virtual ACompDocFwkModel*	getModelPointer() const;

    // Two size methods overidde the view class to resize the screen 
    virtual ACompDocFwkView&    sizeTo(const ISize& newSize);
    virtual ACompDocFwkView&    moveSizeTo(const IRectangle& newRect);

    void                        drawContents( IPresSpaceHandle& hdl,
                                            const IRectangle& invalidArea,
                                            Boolean metaFile );
    // handle functions
            void                handleFileNew();

    virtual Boolean             handleMouseClicked(IMouseClickEvent&);
    virtual Boolean             handleVirtualKeyPress(IKeyboardEvent&);

    virtual Boolean             handleButtonPressed(ICommandEvent&);

    virtual void                handleNotification( const INotificationEvent& );

protected:
            void                SizeFieldsToScreen(const ISize&);

                                ACompDocFwkView(const ACompDocFwkView&);

private:
    ACompDocFwkView&            operator=( const ACompDocFwkView& );

    IPushButton                 fButton;
    IStaticText                 fDataStaticField1;
    IEntryField                 fDataEntryField1;
    IStaticText                 fDataStaticField2;
    IEntryField                 fDataEntryField2;
    IStaticText                 fMyObjectField;

    // All the handlers                     
    ICommandConnectionTo<ACompDocFwkView>   fButtonHandler;
    IKeyboardConnectionTo<ACompDocFwkView>  fKeyboardHandler;
    IMouseConnectionTo<ACompDocFwkView>     fMouseHandler;
};
#endif
    
