///////////////////////////////////////////////////////////////////////////////
//                                              SAMPLE CODE
//
// FileName: ACDFMdl3.cpp
//
// ClassName: ACompDocFwkModel
//
// Description: Compound Document Framework (SimpleContainer) Model
//              for the container. This sample is the basic container. 
//              By inheriting from IEmbedder class the functionality to insert 
//              an object is all inherited, therefore this sample contains very
//              little. There is no model data, only streaming is provided.
///////////////////////////////////////////////////////////////////////////////
#include "ACDFMdl3.hpp"
#include "ACDFVw3.hpp"

#include <fstream.h>
#include <ibasstrm.hpp>
#include <istatnry.hpp> 
#include <assert.h>
#include <iexcept.hpp>
#include <icconst.h>
#include <iframe.hpp>

TypeExtensionMacro(ACompDocFwkModel)

ACompDocFwkModel::ACompDocFwkModel() 
// Default Constructor
{   IFUNCTRACE_DEVELOP(); }

ACompDocFwkModel::~ACompDocFwkModel()
// Default Destructor
{   IFUNCTRACE_DEVELOP();}

ACompDocFwkModel::ACompDocFwkModel( const ACompDocFwkModel& other ) :
            IEmbedderModel( other )  // Force Assert
// Copy Constructor
{   IFUNCTRACE_DEVELOP();}

IBaseStream& ACompDocFwkModel::operator>>=(IBaseStream& toWhere) const
// Stream member data out
{   IFUNCTRACE_DEVELOP();
    writeVersion(toWhere, kOriginalVersion);
    IEmbedderModel::operator>>=( toWhere );
    return toWhere;
}


IBaseStream& ACompDocFwkModel::operator<<=(IBaseStream& fromWhere)
// Stream member data in
{   IFUNCTRACE_DEVELOP();
    switch (readVersion(fromWhere))
    {
        case kOriginalVersion:
            IEmbedderModel::operator<<=( fromWhere );
            break;
        default:
            ITHROWLIBRARYERROR(IC_STREAM_VERSION_UNSUPPORTED, 
                               IBaseErrorInfo::invalidRequest,
                               IException::recoverable);
    }
    return fromWhere;
}

// IComponent Stationery class is created using the model, view

IComponentStationeryFor<ACompDocFwkModel,ACompDocFwkView> CompDocFwkStationery;

int main( int argc, char* argv[] )
{
    int ireturn;
    try
    {
        // Stationery run will eventually call the IApplication::current().run()
        ireturn =  CompDocFwkStationery.run( argc, argv );
    }

    catch (IException& exc)
    {
        ofstream  errorFile("errormsg.log",ios::app);
        const IExceptionLocation *excLocate = exc.locationAtIndex(0);

        errorFile << "Exception on exit " << exc.text() << endl;
        errorFile << "File : " << excLocate->fileName() << endl;
        errorFile << "Function : " << excLocate->functionName() << endl;
        errorFile << "Line : " << excLocate->lineNumber() << endl;

        cout << "Exception on exit " << exc.text() << endl;
        cout << "File : " << excLocate->fileName() << endl;
        cout << "Function : " << excLocate->functionName() << endl;
        cout << "Line : " << excLocate->lineNumber() << endl;
    }
    return ireturn;
}
    
