///////////////////////////////////////////////////////////////////////////////
//                                              SAMPLE CODE
//
// FileName: ACDFVw3.cpp
//
// ClassName: ACompDocFwkView
//
// Description: Compound Document Framework Simple Container View
//              In this sample the view inherits from the IView class 
//              therefore all functionality is inherited from the base class
///////////////////////////////////////////////////////////////////////////////
#include "ACDFVw3.hpp"
#include "acdfres3.h"

#include <iframe.hpp>  // must be included to set the icon
#include <istring.hpp>
#include <igstring.hpp>
#include <igrect.hpp>
#include <igrafctx.hpp>
#include <igelipse.hpp>
#include <igline.hpp>
#include <igarc.hpp>
#include <iguibndl.hpp> // must be include after windows.h
#include <icolor.hpp>

ACompDocFwkView::ACompDocFwkView(IGUIBundle& bundle ) :
                 IView(bundle)
// Constructor 
{   IFUNCTRACE_DEVELOP();
    bundle.frameWindow().setIcon(IC_ACDF3);
}

ACompDocFwkView::~ACompDocFwkView()
// Destructor - resize the window
{   IFUNCTRACE_DEVELOP();}

void ACompDocFwkView::initialize()
// Intialize code e.g build menus
{   IFUNCTRACE_DEVELOP();

    IView::initialize();
    bundle().objectView().setBackgroundColor(IColor(64,128,128)); // Set the color to green
}

void ACompDocFwkView::drawContents( IPresSpaceHandle& hdl,
                      const IRectangle& invalidArea,
                      Boolean metaFile)
//  We can override "drawContents" if we want to optimize our drawing
//  or do things differently when rendering to a meta-file (where controls
//  won't be displayed).
{   IFUNCTRACE_DEVELOP();

    if (metaFile)
    {
    // Place the embedded image code here !!!!
        IGString myText (IApplication::current().userResourceLibrary().loadString(STR_METAFILE),IPoint(30,70));
        IGraphicContext ctxt ( hdl );
        IGEllipse myEllipse(IRectangle(IPoint(10,10),IPoint(210,50)));
        IGLine myLine1(IPoint(10,30),IPoint(40,150));
        IGLine myLine2(IPoint(210,30),IPoint(190,150));
        IG3PointArc myArc(IPoint(40,150),IPoint(75,170),IPoint(190,150));

        myEllipse.drawOn( ctxt) ;
        myLine1.drawOn( ctxt) ;
        myLine2.drawOn( ctxt) ;
        myArc.drawOn( ctxt) ;
        myText.drawOn( ctxt) ;
   }

}
