///////////////////////////////////////////////////////////////////////////////
//                         SAMPLE CODE
//
// FileName: ACDFVw3.hpp
//
// ClassName: ACompDocFwkView
//
// Description: Header file for the Compound Document Framework Simple Container View
//              In this sample the view inherits from the IView class 
//              therefore all functionality is inherited from the base class
///////////////////////////////////////////////////////////////////////////////
#ifndef _COMPDOCFWK_VIEW_
#define _COMPDOCFWK_VIEW_

#ifdef IC_TRACE_DEVELOP
    #include <itrace.hpp>
#else
    #define IFUNCTRACE_DEVELOP()
    #define ITRACE_DEVELOP(x)
#endif

#include <iview.hpp>

class ACompDocFwkView : public IView // Inherit from IView class
{
public:
                        ACompDocFwkView(IGUIBundle& );
    virtual             ~ACompDocFwkView();

    virtual void        initialize();
    virtual void        drawContents( IPresSpaceHandle&,
                                      const IRectangle& invalidArea,
                                      Boolean metaFile);

protected:
                        ACompDocFwkView(const ACompDocFwkView&);

private:
    ACompDocFwkView&    operator=( const ACompDocFwkView& );

};
#endif
    
