///////////////////////////////////////////////////////////////////////////////
//                                              SAMPLE CODE
//
// FileName: ACDFVw4.hpp
//
// ClassName: ACompDocFwkView
//
// Description: Compound Document Framework (SimpleContainer) View
//              This is a container view which inherits from IView.
//              This sample illustrates how the embedded object can be
//              manipulated (shrink and grow)  on the screen. It also 
//              shows how to programmatically select,unselect and launch the 
//              embedded objects.                
///////////////////////////////////////////////////////////////////////////////
#ifndef _COMPDOCFWK_VIEW_
#define _COMPDOCFWK_VIEW_

#ifdef IC_TRACE_DEVELOP
    #include <itrace.hpp>
#else
    #define IFUNCTRACE_DEVELOP()
    #define ITRACE_DEVELOP(x)
#endif

#include <iview.hpp>

#include <icmdhdr.hpp>

class ACompDocFwkModel;

class ACompDocFwkView : public IView  // Inherit from IView class
{
public:
                                ACompDocFwkView(IGUIBundle& );
    virtual                     ~ACompDocFwkView();

    virtual void                initialize();

    // This is convenience function that downcast the model
    virtual ACompDocFwkModel*   getModelPointer() const;

    virtual void                drawContents(IPresSpaceHandle& hdl,
                                             const IRectangle& invalidArea,
                                             Boolean metaFile);

            void                handleSelectAll(Boolean );

protected:
    // handle functions
    virtual Boolean            handleCommand(ICommandEvent&);

                                ACompDocFwkView(const ACompDocFwkView&);

private:
    ACompDocFwkView&            operator=( const ACompDocFwkView& );
    // All the handlers 
    ICommandConnectionTo<ACompDocFwkView>   fCommandHandler;
};
#endif
