///////////////////////////////////////////////////////////////////////////////
//                                              SAMPLE CODE
//
// FileName: ACDFMdl5.cpp
//
// ClassName: ACompDocFwkModel
//
// Description: Compound Document Framework Model
//              This sample demonstrates the use of streaming collection class.
//              A collection of the TPerson is created depending on the screen
//              selection in the view.
//              This sample show how to use both the ISequence collection class
//              and the IKeySet collection class
//              There are also 2 different types of notification messages sent 
//              to the view depending on what is changed.
///////////////////////////////////////////////////////////////////////////////
#include "ACDFMdl5.hpp"
#include "ACDFVw5.hpp"
#include "ACDFSt5.hpp"
#include <imsgbox.hpp>

#include <fstream.h>
#include <inotifev.hpp>
#include <iexcept.hpp>
#include <icconst.h>
#include <ibasstrm.hpp>
#include <assert.h>
#include <iframe.hpp>

TypeExtensionMacro(ACompDocFwkModel)

const INotificationId ACompDocFwkModel::kListChanged = "List changed";
const INotificationId ACompDocFwkModel::kSelectionChanged = "Selection changed";

ACompDocFwkModel::ACompDocFwkModel()  
// Default Constructor
{       IFUNCTRACE_DEVELOP();
    fType = kSeq; // Default setting
}

ACompDocFwkModel::~ACompDocFwkModel()
// Default Destructor
{       IFUNCTRACE_DEVELOP();}

ACompDocFwkModel::ACompDocFwkModel( const ACompDocFwkModel& other ) :
        IModel( other ) // force assert
// Copy Constructor
{       IFUNCTRACE_DEVELOP(); }


IBaseStream& ACompDocFwkModel::operator>>=(IBaseStream& toWhere) const
// Stream member data out
{       IFUNCTRACE_DEVELOP();
    writeVersion(toWhere, kOriginalVersion);
    IModel::operator>>=( toWhere );
    fPersonList >>= toWhere;
    fPersonKeyList >>= toWhere;
    return toWhere;
}


IBaseStream& ACompDocFwkModel::operator<<=(IBaseStream& fromWhere)
// Stream member data in
{       IFUNCTRACE_DEVELOP();
    switch (readVersion(fromWhere))
    {
        case kOriginalVersion:
            IModel::operator<<=( fromWhere );
            fPersonList <<= fromWhere;
            fPersonKeyList <<= fromWhere;
            break;
        default:
        ITHROWLIBRARYERROR(IC_STREAM_VERSION_UNSUPPORTED, 
              IBaseErrorInfo::invalidRequest,
              IException::recoverable);
    }
    return fromWhere;
}


void ACompDocFwkModel::addToList(TPerson& myPerson)
// Add the person to the list
{       IFUNCTRACE_DEVELOP();

    if (fType == kSeq)
    {
        IElemPointer<TPerson> elem = new TPerson(myPerson);
        fPersonList.addAsLast(elem);
    }
    if (fType == kKey)
    {
        fPersonKeyList.add(myPerson);
    }
    
    notifyOfChange(INotificationEvent(kListChanged, notifier()));
}       
void ACompDocFwkModel::deleteFromList(TPerson& myPerson)
// Add the person to the list
{       IFUNCTRACE_DEVELOP();
    
    switch (fType)
    {
        case kSeq:
        {
            unsigned long myNumberPersons = fPersonList.numberOfElements();
            for (int i=1;i <= myNumberPersons; i++)
            {
                TPerson *thisPerson = fPersonList.elementAtPosition(i);
                if (myPerson == *thisPerson)
                {
                    fPersonList.removeAtPosition(i);
                    delete thisPerson;
                    break;
                }
            }
            break;
        }
        case kKey:
        {
            IString myKey = fPersonKeyList.key(myPerson);
            ICursor& myCursor = *fPersonKeyList.newCursor();
            if (fPersonKeyList.locateElementWithKey(myKey, myCursor))
            {
                fPersonKeyList.removeAt(myCursor);
            }
            break;
        }
    }
    notifyOfChange(INotificationEvent(kListChanged, notifier()));
}       

TPerson ACompDocFwkModel::getPersonFirstList()
// Get person from list
{       IFUNCTRACE_DEVELOP();
    
    TPerson myPerson;

    if (fType == kSeq)
    {
        fCursor = fPersonList.newCursor();
        if (fPersonList.setToFirst(*fCursor))
        {
            TPerson *thePerson = fPersonList.elementAt(*fCursor);
            myPerson = *thePerson;
        }
    }
    if (fType == kKey)
    {
        fCursor = fPersonKeyList.newCursor();
        if (fPersonKeyList.setToFirst(*fCursor))
            myPerson = fPersonKeyList.elementAt(*fCursor);
    }
    return myPerson;
}

TPerson ACompDocFwkModel::getPersonNextList()
// Get person from list
{       IFUNCTRACE_DEVELOP();

    TPerson myPerson;

    if (fType == kSeq)
    {
        if (fPersonList.setToNext(*fCursor))
        {
            TPerson *thePerson = fPersonList.elementAt(*fCursor);
            myPerson = *thePerson;
        }
    }
    if (fType == kKey)
    {
        if (fPersonKeyList.setToNext(*fCursor))
            myPerson = fPersonKeyList.elementAt(*fCursor);
    }
    return myPerson; // if cursor has not been set
}

TPerson ACompDocFwkModel::getPersonList(long pos, IString name)
// 
{       IFUNCTRACE_DEVELOP();
    if (fType == kSeq)
    {
         TPerson *thePerson = fPersonList.elementAtPosition(pos);
         fSelectedPerson = *thePerson;
    }
    if (fType == kKey)
    {
        fSelectedPerson = fPersonKeyList.elementWithKey(name);
        
    }

    notifyOfChange(INotificationEvent(kSelectionChanged, notifier()));
    return fSelectedPerson;         
}

void ACompDocFwkModel::setCollectionType(CollectionType myType)
// Set List type
{       IFUNCTRACE_DEVELOP();
    fType = myType;
    notifyOfChange(INotificationEvent(kListChanged, notifier()));
}

TPerson ACompDocFwkModel::getSelectedPerson()
// Return the person that was selected
{       IFUNCTRACE_DEVELOP();

    return fSelectedPerson;
}

// IComponent Stationery class is created using the model, view 
ACompDocFwkMyStationery CompDocFwkStationery;


int main( int argc, char* argv[] )
{
    int ireturn;
    try
    {
        // Stationery run will eventually call the IApplication::current().run()
        ireturn =  CompDocFwkStationery.run( argc, argv );
    }

    catch (IException& exc)
    {
        ofstream  errorFile("errormsg.log",ios::app);
        const IExceptionLocation *excLocate = exc.locationAtIndex(0);

        errorFile << "Exception on exit " << exc.text() << endl;
        errorFile << "File : " << excLocate->fileName() << endl;
        errorFile << "Function : " << excLocate->functionName() << endl;
        errorFile << "Line : " << excLocate->lineNumber() << endl;

        cout << "Exception on exit " << exc.text() << endl;
        cout << "File : " << excLocate->fileName() << endl;
        cout << "Function : " << excLocate->functionName() << endl;
        cout << "Line : " << excLocate->lineNumber() << endl;
    }
    return ireturn;
}
    
