///////////////////////////////////////////////////////////////////////////////
//                      SAMPLE CODE
//
// FileName: ACDFMdl5.hpp
//
// ClassName: ACompDocFwkModel
//
// Description: Compound Document Framework Header file for the Model Class
//              This sample demonstrates the use of streaming collection class.
//              A collection of the TPerson is created depending on the screen
//              selection in the view.
//              This sample show how to use both the ISequence collection class
//              and the IKeySet collection class
//              There are also 2 different types of notification messages sent 
//              to the view depending on what is changed.
///////////////////////////////////////////////////////////////////////////////
#ifndef _COMPDOCFWK_MODEL_
#define _COMPDOCFWK_MODEL_

#ifdef IC_TRACE_DEVELOP
    #include <itrace.hpp>
#else
    #define IFUNCTRACE_DEVELOP()
    #define ITRACE_DEVELOP(x)
#endif

#include <inotifev.hpp>

#include <imodel.hpp>
#include <iseq.h>
#include <ikeyset.h>
#include <iptr.h>
#include "ACDFPsn5.hpp"

class ACompDocFwkModel : public IModel  // Inherit from IModel
{
public:
    TypeExtensionDeclarationsMacro(ACompDocFwkModel)
    typedef ISequence< IElemPointer<TPerson> >   PersonList;
    typedef IKeySet<TPerson, IString >           PersonKeyList;

    static const INotificationId kListChanged;   // When element is add to the list
    static const INotificationId kSelectionChanged; // When the current selection changes 

    enum CollectionType     { kSeq, kKey } ;

                            ACompDocFwkModel();
    virtual                 ~ACompDocFwkModel();
    
    virtual IBaseStream&    operator>>=( IBaseStream& towhere ) const;
    virtual IBaseStream&    operator<<=( IBaseStream& fromwhere );

    void                    addToList(TPerson&);
    void                    deleteFromList(TPerson&);

    TPerson                 getPersonFirstList();
    TPerson                 getPersonNextList();
    TPerson                 getPersonList(long,IString);
    TPerson                 getSelectedPerson();

    void                    setCollectionType(CollectionType myType);

protected:
                            ACompDocFwkModel( const ACompDocFwkModel&);

private:
    enum                    { kOriginalVersion };
    ACompDocFwkModel&       operator=(const ACompDocFwkModel&);

    CollectionType          fType;
    PersonList              fPersonList;
    PersonKeyList           fPersonKeyList;
    TPerson                 fSelectedPerson;

    ICursor*                fCursor;
};

#endif
