///////////////////////////////////////////////////////////////////////////////
//                      SAMPLE CODE
//
// FileName:     ACDFPsn5.cpp
//
// ClassName:    APerson
//
// Description:  Compound Document Framework Collection Streaming
//               A collection of this is class used in both the keyed
//               and sequence collections.
///////////////////////////////////////////////////////////////////////////////
#include "ACDFPsn5.hpp"
#include <iexcept.hpp>
#include <icconst.h>
#include <assert.h>

TypeExtensionMacro(TPerson)

TPerson::TPerson(const IString& name, const IString& age)
// Constructor 
: fName(name), fAge(age)
{   IFUNCTRACE_DEVELOP();}

TPerson::TPerson()
// Default Constructor
: fName(), fAge(0)
{   IFUNCTRACE_DEVELOP();}

IBaseStream&
TPerson::operator>>=(IBaseStream& toWhere) const
// Stream class out
{   IFUNCTRACE_DEVELOP();

    writeVersion(toWhere,kOriginalVersion);
    fName >>= toWhere;
    fAge >>= toWhere;
    return toWhere;
}

IBaseStream&
TPerson::operator<<=(IBaseStream& fromWhere)
//Stream class in
{   IFUNCTRACE_DEVELOP();

    switch (readVersion(fromWhere)) 
    {
        case kOriginalVersion:
            fName <<= fromWhere;
            fAge <<= fromWhere;
            break;
        default:
            ITHROWLIBRARYERROR(IC_STREAM_VERSION_UNSUPPORTED, 
                      IBaseErrorInfo::invalidRequest,
                      IException::recoverable);
    }
    return fromWhere;
}


IString TPerson::getName() const
// Return the name 
{   IFUNCTRACE_DEVELOP();
    return fName;
}

IString TPerson::getAge() const
// Return the age
{   IFUNCTRACE_DEVELOP();
    return fAge;
}

IBoolean TPerson::operator==(TPerson& myPerson)
// Compare to the member data
{   IFUNCTRACE_DEVELOP();
    if (fName == myPerson.fName && fAge == myPerson.fAge)
        return true;
    else
        return false;
}

    
