///////////////////////////////////////////////////////////////////////////////
//                      SAMPLE CODE
//
// FileName:     ACDFPsn5.hpp
//
// ClassName:    APerson
//
// Description:  Compound Document Framework Collection Streaming
//               A collection of this is class used in both the keyed
//               and sequence collections.
///////////////////////////////////////////////////////////////////////////////
#ifndef _PERSON_
#define _PERSON_

#ifdef IC_TRACE_DEVELOP
    #include <itrace.hpp>
#else
    #define IFUNCTRACE_DEVELOP()
    #define ITRACE_DEVELOP(x)
#endif

#include <ibasstrm.hpp>
#include <imetatyp.hpp>
#include <istring.hpp>

class TPerson
{
public:
    TypeExtensionDeclarationsMacro(TPerson) //Streaming template

                                TPerson(const IString& name, const IString& age);
                                TPerson();

    IString                     getName() const;
    IString                     getAge() const;

    virtual     IBaseStream&    operator>>=(IBaseStream& towhere) const;
    virtual     IBaseStream&    operator<<=(IBaseStream& towhere);
                Boolean         operator==(TPerson& );

    // Required to support TPerson's in IKeySet's
    friend const IString&       key(const TPerson& k)
    { 
        return k.fName; 
    }


private:
    enum EVersion               { kOriginalVersion };
    IString                     fName;
    IString                     fAge;
};

#endif
