///////////////////////////////////////////////////////////////////////////////
//                                              SAMPLE CODE
//
// FileName: ACDFVw5.cpp
//
// ClassName: ACompDocFwkView
//
// Description: Compound Document Framework Streaming Server View
//                              This sample show how to add elements to a collection class
//              and stream the colllection out and in.
//              Basically the screen allows the user to capture Name and Age
//              and add them to a list (collection). The type of list the
//              name is added to depends on which of the radio buttons have 
//              been selected
///////////////////////////////////////////////////////////////////////////////
#include "ACDFMdl5.hpp"
#include "ACDFVw5.hpp"
#include "acdfres5.h"

#include <inotifev.hpp>
#include <icolor.hpp>
#include <igstring.hpp>
#include <igrect.hpp>
#include <igrafctx.hpp>
#include <imsgbox.hpp>
#include <assert.h>
#include <iframe.hpp>
#include <iguibndl.hpp> // must be include after windows.h
#include <ititle.hpp>

ACompDocFwkView::ACompDocFwkView(IGUIBundle& bundle ) :
    IView(bundle),
    fDataName (ID_NAME_FIELD,  this, this),
    fDataAge (ID_AGE_FIELD,  this, this),
    fPersonListBox (ID_LIST_FIELD,  this, this),
    fStaticName (ID_NAME_STATIC,  this, this),
    fStaticAge (ID_AGE_STATIC,  this, this),
    fStaticList (ID_LIST_STATIC,  this, this),
    fButtonAdd(ID_ADD_PUSH,  this, this),
    fButtonDelete(ID_DEL_PUSH, this, this),
    fRadioSeq (ID_RADIO_SEQ,  this, this),
    fRadioKey (ID_RADIO_KEY,  this, this),
    fCommandHandler(*this, handleCommand),
    fSelectHandler(*this)
// Constructor
{   IFUNCTRACE_DEVELOP();
    bundle.frameWindow().setIcon(IC_ACDF5);
}

ACompDocFwkView::~ACompDocFwkView()
// Destructor  - Stop handling events
{   IFUNCTRACE_DEVELOP(); 
    fCommandHandler.stopHandlingEventsFor(this);
    fSelectHandler.stopHandlingEventsFor(this);
}

ACompDocFwkModel* ACompDocFwkView::getModelPointer() const
// Get the pointer to the model 
{   IFUNCTRACE_DEVELOP();
    ACompDocFwkModel* fOurModel = NULL;
    ::dynamicCastTo( fOurModel,model() );
    return fOurModel;
}

void ACompDocFwkView::initialize()
// Intialize code - set the size of the fields on the view
{   IFUNCTRACE_DEVELOP();
    IView::initialize();
    bundle().objectView().setBackgroundColor(IColor(64,128,128)); // Set the color to green

    fStaticName.moveSizeTo(IRectangle(IPoint(5,5),IPoint(55,35)));
    fStaticName.setText(STR_NAME); 
    fStaticAge.moveSizeTo(IRectangle(IPoint(5,40),IPoint(55,70)));
    fStaticAge.setText(STR_AGE);
    fStaticList.moveSizeTo(IRectangle(IPoint(5,110),IPoint(55,140)));
    fStaticList.setText(STR_LIST);

    fDataName.moveSizeTo(IRectangle(IPoint(70,5),IPoint(200 ,35)));
    fDataAge.moveSizeTo(IRectangle(IPoint(70,40),IPoint(200 ,70)));
    fPersonListBox.moveSizeTo(IRectangle(IPoint(70,110),IPoint(200 ,250)));
    
    fButtonAdd.moveSizeTo(IRectangle(IPoint(220,5), IPoint(300,35)));
    fButtonDelete.moveSizeTo(IRectangle(IPoint(220,40), IPoint(300,70)));
    fRadioSeq.moveSizeTo(IRectangle(IPoint(220,110),IPoint(350,140)));
    fRadioKey.moveSizeTo(IRectangle(IPoint(220,150),IPoint(350,180)));
    fButtonAdd.setText(STR_ADD);
    fButtonDelete.setText(STR_DELETE);
    fRadioSeq.setText(STR_SEQUENCE);
    fRadioKey.setText(STR_KEYED);
    fRadioSeq.click();
    fRadioSeq.disableTabStop();
    
    ITitle myTitle(&bundle().frameWindow());
    myTitle.setText (IApplication::current().userResourceLibrary().loadString(ID_ACDF5));

    fDataName.enableTabStop();
    fCommandHandler.handleEventsFor(this);
    fSelectHandler.handleEventsFor(this);
}

void ACompDocFwkView::drawContents( IPresSpaceHandle& hdl,
                  const IRectangle& invalidArea,
                  Boolean metaFile )
//  We can override "drawContents" if we want to optimize our drawing
//  or do things differently when rendering to a meta-file (where controls
//  won't be displayed).
{   IFUNCTRACE_DEVELOP();
    if (metaFile)
    {
    // Place the embedded image here. This will be displayed when server in
    // embedded but inactive.
        IGraphicContext ctxt ( hdl );
        ctxt.setFillColor(IColor::white);
        IGRectangle myRect(IRectangle(IPoint(20,20), IPoint(300,100)));
        myRect.drawOn( ctxt );

        if (fSelectedPerson.getName().length() > 0 )
        {
            IGString strName (IApplication::current().userResourceLibrary().loadString(STR_NAME),IPoint(25,20));
            IGString strAge  (IApplication::current().userResourceLibrary().loadString(STR_AGE), IPoint(25,50));
            IGString myStrName(fSelectedPerson.getName(),IPoint(100,20));
            IGString myStrAge(fSelectedPerson.getAge(),IPoint(100,50));
            strName.drawOn( ctxt );
            myStrName.drawOn( ctxt );
            strAge.drawOn( ctxt );
            myStrAge.drawOn( ctxt );
        }
        else
        {
            IGString str (IApplication::current().userResourceLibrary().loadString(STR_NOTHING),IPoint(20,20));
            str.drawOn( ctxt );
        }
        
    }
}

void ACompDocFwkView::handleNotification( const INotificationEvent& event)
// Handle the notification events
{   IFUNCTRACE_DEVELOP();

    ACompDocFwkModel* fOurModel = getModelPointer();
    assert(fOurModel != NULL);

    if (event.notificationId() == fOurModel->kSelectionChanged )
    {   
        fSelectedPerson = fOurModel->getSelectedPerson();
    }    
    else  // This is to update on List change
    {
        fPersonListBox.removeAll();
        TPerson myPerson = fOurModel->getPersonFirstList();
    
        while (myPerson.getName().length() != 0)
        {
            fPersonListBox.addAsLast(myPerson.getName());       
            myPerson = fOurModel->getPersonNextList();
        }
    }
}
void ACompDocFwkView::handleSelectAll(Boolean select)
// Handle the file select all to show that all has been selected
{   IFUNCTRACE_DEVELOP();

    unsigned char myRed,myBlue,myGreen;

    IColor myColor (fDataName.backgroundColor());
    myRed = (255 - myColor.redMix());
    myGreen = (255 - myColor.greenMix());
    myBlue = (255 - myColor.blueMix());
    fDataName.setBackgroundColor(IColor(myRed,myGreen,myBlue));

    myColor = fDataName.foregroundColor();
    myRed = (255 - myColor.redMix());
    myGreen = (255 - myColor.greenMix());
    myBlue = (255 - myColor.blueMix());
    fDataName.setForegroundColor(IColor(myRed,myGreen,myBlue));
    
    myColor = fDataAge.backgroundColor();
    myRed = (255 - myColor.redMix());
    myGreen = (255 - myColor.greenMix());
    myBlue = (255 - myColor.blueMix());
    fDataAge.setBackgroundColor(IColor(myRed,myGreen,myBlue));    

    myColor = fDataAge.foregroundColor();
    myRed = (255 - myColor.redMix());
    myGreen = (255 - myColor.greenMix());
    myBlue = (255 - myColor.blueMix());
    fDataAge.setForegroundColor(IColor(myRed,myGreen,myBlue));    
    
    myColor = fPersonListBox.backgroundColor();
    myRed = (255 - myColor.redMix());
    myGreen = (255 - myColor.greenMix());
    myBlue = (255 - myColor.blueMix());
    fPersonListBox.setBackgroundColor(IColor(myRed,myGreen,myBlue));    

    myColor = fPersonListBox.foregroundColor();
    myRed = (255 - myColor.redMix());
    myGreen = (255 - myColor.greenMix());
    myBlue = (255 - myColor.blueMix());
    fPersonListBox.setForegroundColor(IColor(myRed,myGreen,myBlue));    
    refresh();
}

void ACompDocFwkView::handleFileNew()
// Handle the file new to clear the screen
{   IFUNCTRACE_DEVELOP();
    fDataName.removeAll();
    fDataAge.removeAll();
    fRadioSeq.select();
}

Boolean ACompDocFwkView::handleCommand(ICommandEvent& event)
// Handle all the menu and push button commands
{   IFUNCTRACE_DEVELOP();

    Boolean bReturn = false;
    switch( event.commandId() )
    {
        case ID_ADD_PUSH:
        case MI_ADD:
        {
            addToSeq();
            fDataName.removeAll();
            fDataAge.removeAll();
            bReturn = true;
            break;                  
        }
        case ID_DEL_PUSH:
        case MI_DELETE:
        {
            deleteFromSeq();
            fDataName.removeAll();
            fDataAge.removeAll();
            bReturn = true;
            break;
        }
    }
    return bReturn;
}

Boolean ACompDocFwkView::handleSelected(IControlEvent& event)
// Handle all the selections on Radio button and List Boxes
{   IFUNCTRACE_DEVELOP();

    ACompDocFwkModel* fOurModel = getModelPointer();
    assert(fOurModel != NULL);

    Boolean bReturn = false;
                
    switch( event.controlId() )
    {
        case ID_RADIO_SEQ:
        {
            fOurModel->setCollectionType(fOurModel->kSeq);
            fDataName.removeAll();
            fDataAge.removeAll();
            bReturn = true;
            break;                  
        }
        case ID_RADIO_KEY:
        {
            fOurModel->setCollectionType(fOurModel->kKey);
            fDataName.removeAll();
            fDataAge.removeAll();
            bReturn = true;
            break;
        }
        case ID_LIST_FIELD:
        {
            long mySelection = fPersonListBox.selection();
            IString myText =  fPersonListBox.itemText(mySelection);
            TPerson myPerson = fOurModel->getPersonList((mySelection+1),myText);
            fDataName.setText(myPerson.getName());
            fDataAge.setText(myPerson.getAge());
            bReturn = true;
            break;
        }
    }
    return bReturn;
}

void ACompDocFwkView::addToSeq()
// Add to the list
{   IFUNCTRACE_DEVELOP();

    ACompDocFwkModel* fOurModel = getModelPointer();
    assert(fOurModel != NULL);

    TPerson myPerson(fDataName.text(), fDataAge.text());
    fOurModel->addToList(myPerson);
}       
    
void ACompDocFwkView::deleteFromSeq()
// Delete from the list
{   IFUNCTRACE_DEVELOP();

    ACompDocFwkModel* fOurModel = getModelPointer();
    assert(fOurModel != NULL);

    TPerson myPerson(fDataName.text(), fDataAge.text());
    fOurModel->deleteFromList(myPerson);
}       

