///////////////////////////////////////////////////////////////////////////////
//                    	SAMPLE CODE
//
// FileName: ACDFVw5.hpp
//
// ClassName: ACompDocFwkView
//
// Description: Compound Document Framework header file for the view class
//            	This sample show how to add elements to a collection class
//              and stream the colllection out and in.
//              Basically the screen allows the user to capture Name and Age
//              and add them to a list (collection). The type of list the
//              name is added to depends on which of the radio buttons have 
//              been selected
///////////////////////////////////////////////////////////////////////////////
#ifndef _COMPDOCFWK_VIEW_
#define _COMPDOCFWK_VIEW_

#ifdef IC_TRACE_DEVELOP
    #include <itrace.hpp>
#else
    #define IFUNCTRACE_DEVELOP()
    #define ITRACE_DEVELOP(x)
#endif

#include "acdfpsn5.hpp"
#include <iview.hpp>
#include <ientryfd.hpp>
#include <ipushbut.hpp>
#include <icmdhdr.hpp>
#include <icanvas.hpp>
#include <istattxt.hpp>
#include <ilistbox.hpp>
#include <iradiobt.hpp>
#include <itselhdr.hpp>

class ACompDocFwkModel;

class ACompDocFwkView : public IView
{
public:
                                ACompDocFwkView(IGUIBundle& );
    virtual                     ~ACompDocFwkView();

    virtual void                initialize();

    // This is convenience function that downcast the model
    virtual ACompDocFwkModel*   getModelPointer() const;

    virtual void                drawContents( IPresSpaceHandle&,
                                              const IRectangle& invalidArea,
                                              Boolean metaFile );

    virtual Boolean             handleCommand(ICommandEvent&);
    virtual Boolean             handleSelected(IControlEvent&);

    virtual void                handleNotification( const INotificationEvent& );

            void                handleSelectAll(Boolean);
            void                handleFileNew();

            void                addToSeq();
            void                deleteFromSeq();

protected:
                                ACompDocFwkView(const ACompDocFwkView&);

private:
    ACompDocFwkView&            operator=( const ACompDocFwkView& );

    TPerson                     fSelectedPerson;
    IEntryField                 fDataName;
    IEntryField                 fDataAge;
    IListBox                    fPersonListBox;
                                                                      
    IStaticText                 fStaticName;
    IStaticText                 fStaticAge;
    IStaticText                 fStaticList;

    IPushButton                 fButtonAdd;
    IPushButton                 fButtonDelete;

    IRadioButton                fRadioSeq;
    IRadioButton                fRadioKey;

    ICommandConnectionTo<ACompDocFwkView>	fCommandHandler;
    ISelectConnectionTo<ACompDocFwkView>    fSelectHandler;
};
#endif
    
