///////////////////////////////////////////////////////////////////////////////
//                                              SAMPLE CODE
//
// FileName: ACDFBd6.cpp
//
// ClassName: ACompDocFwkMyBundle
//
// Description: This is the bundle class. The reason a user version of the 
//              IGUIbundle class is to try and get the help to work by setting
//              the default style before the view is created
///////////////////////////////////////////////////////////////////////////////
#include "ACDFBd6.hpp"
#include <ireslib.hpp>
#include <imsgbox.hpp>   
#include "aCDFres6.h"
#include <ifont.hpp>
#include <iframe.hpp> 

ACompDocFwkMyBundle::ACompDocFwkMyBundle() 
// Constructor
{       IFUNCTRACE_DEVELOP();}

ACompDocFwkMyBundle::~ACompDocFwkMyBundle()
// Destructor
{       IFUNCTRACE_DEVELOP();
    delete fHelpWindow;
    delete fStatusLine; 
    delete fButtons;
    delete fLeftButton;
    delete fCenterButton;
    delete fRightButton;
    delete fHelpButton;
    delete fInfoArea;
}

Boolean ACompDocFwkMyBundle::adoptFrameWindow( IComponentFrameWindow* componentFrameWindow)
{       IFUNCTRACE_DEVELOP();

    IGUIBundle::adoptFrameWindow( componentFrameWindow);
    IHelpWindow::setDefaultStyle(IHelpWindow::defaultStyle() |
                IHelpWindow::ipfCompatible ); 

    fHelpWindow = new IHelpWindow (HELP_TABLE,&frameWindow());
    fHelpWindow->setActiveWindow(&frameWindow());

    try
    {
        fHelpWindow->addLibraries("aCDFhlp6.hlp");  
        fHelpWindow->setTitle(STR_HTITLE);        
    }
    catch (...)
    {
        IMessageBox msgBox (IWindow::desktopWindow());
        msgBox.show(STR_HELP_NOT_FOUND, IMessageBox::warning );
    }

    fStatusLine = new IStaticText (WND_STATUS,&frameWindow(),&frameWindow());

    frameWindow().addExtension(fStatusLine, 
                IFrameWindow::aboveClient,
                IFont(fStatusLine).maxCharHeight());

    fInfoArea = new IInfoArea(&frameWindow());
    
    fButtons = new ISetCanvas(WND_BUTTONS,&frameWindow(),&frameWindow());

    fLeftButton = new IPushButton(MI_LEFT,fButtons,fButtons );
    fCenterButton = new IPushButton(MI_CENTER,fButtons,fButtons );
    fRightButton = new IPushButton(MI_RIGHT,fButtons,fButtons);
    fHelpButton = new IPushButton(MI_HELP,fButtons,
                                  fButtons,
                                  IRectangle(),
                                  IPushButton::defaultStyle() | 
                                  IPushButton::help |
                                  IButton::noPointerFocus);

    fLeftButton->setText(STR_LEFTB);
    fCenterButton->setText(STR_CENTERB);
    fRightButton->setText(STR_RIGHTB);
    fHelpButton->setText(STR_HELPB);
    fInfoArea->setInactiveText(STR_INFO);

    fLeftButton->enableTabStop();
    fButtons->setMargin(ISize());
    fButtons->setPad(ISize());
    frameWindow().addExtension(fButtons,
                                IFrameWindow::belowClient,
                                (unsigned long)fButtons->minimumSize().height());

    frameWindow().setExtensionSize(fInfoArea, IFont(fInfoArea).maxCharHeight());
    return true;

}
IHelpWindow* ACompDocFwkMyBundle::helpWindow()
// Return a pointer to the help window
{       IFUNCTRACE_DEVELOP();
    return fHelpWindow;
}

IInfoArea* ACompDocFwkMyBundle::infoArea()
// Return a pointer to the info area
{       IFUNCTRACE_DEVELOP();
    return fInfoArea;
}
IStaticText* ACompDocFwkMyBundle::statusLine()
// Return a pointer to the status line
{       IFUNCTRACE_DEVELOP();
    return fStatusLine;
}

