///////////////////////////////////////////////////////////////////////////////
//                      SAMPLE CODE
//
// FileName: ACDFDlg6.cpp
//
// ClassName: ATextDialog
//
// Description: Conversion of the Hello World 5 Sample
//
///////////////////////////////////////////////////////////////////////////////
#include <ibase.hpp>   
#include <istring.hpp> 
#include <ireslib.hpp> 

#include "acdfres6.h"
#include "acdfdlg6.hpp"

ATextDialog :: ATextDialog(IString & textString, IWindow * ownerWnd):
     IFrameWindow(IResourceId(WND_TEXTDIALOG),
                  IWindow::desktopWindow(),
                  ownerWnd,
                  IRectangle(29,50,313,290).moveBy(ownerWnd->rect().bottomLeft()),
                  IWindow::synchPaint
                  |IWindow::clipSiblings
                  |IWindow::saveBits
                  |dialogBackground
                  |dialogBorder
                  |systemMenu
                  |titleBar),
     clientCanvas(WND_MCCANVAS,
                  this,
                  this),
     buttons(WND_STCANVAS, 
                  &clientCanvas,
                  &clientCanvas),
     statText(DID_STATIC,
                  &clientCanvas,
                  &clientCanvas),          
     textField( DID_ENTRY,
                  &clientCanvas,
                  &clientCanvas),
     pushButton1( DID_OK,
                  &buttons,
                  &buttons),
     pushButton2(DID_CANCEL,
                  &buttons,
                  &buttons),
     dialogCommandHandler(this),
     saveText(textString)
// Contruct the dialog as a frame window owned by the window passed
{   IFUNCTRACE_DEVELOP();

    textField.setText(saveText);                                              
    textField.disableAutoScroll().enableMargin().enableTabStop();             

    statText.setText(DID_STATIC);                                             

    pushButton1.enableDefault().setText(IResourceId(DID_OK)).enableTabStop(); 
    pushButton2.setText(IResourceId(DID_CANCEL));                             
    buttons.setPackType(ISetCanvas::expanded).setMargin(ISize());             

    //  Position the dialog controls in the multicell canvas.                 
    clientCanvas.addToCell(&statText , 2, 4);                                 
    clientCanvas.addToCell(&textField, 2, 7);                                 
    clientCanvas.addToCell(&buttons,   2,15);                                 

    //  Set the multicell canvas as the ATextDialog client window.              
    //  Have the command handler start handling events for the frame window.    
    //  Set the focus to the entry field.                                       
    setClient( &clientCanvas );                                               
    dialogCommandHandler.handleEventsFor(this);                               
    textField.setFocus();                                                     

}

ATextDialog :: ~ATextDialog()
// Destructor for the dialog frame
{   IFUNCTRACE_DEVELOP();
    dialogCommandHandler.stopHandlingEventsFor(this);                         
}

ATextDialog& ATextDialog::setTextFromEntryField()                                      
 //Update the reference
{   IFUNCTRACE_DEVELOP();
    saveText = textField.text();                                              
    return (*this);             //Return a reference to the frame   
} 

ADialogCommandHandler :: ADialogCommandHandler(ATextDialog *dialogFrame)
  :frame(dialogFrame)
//  Constructs the command handler for the dialog box.
{   IFUNCTRACE_DEVELOP();}

    Boolean ADialogCommandHandler :: command(ICommandEvent & cmdEvent) 
    // Handle menu commands for dialog window
{   IFUNCTRACE_DEVELOP();
  Boolean eventProcessed(true);         //Assume event will be processed    

    // Depending on the command event ID, optionally update the Hello World text;
    // then dismiss the text dialog passing the event ID as the result.

    switch (cmdEvent.commandId())
    { 
        case DID_OK:                                                            
            frame->setTextFromEntryField();                                       
            frame->dismiss(DID_OK);                                               
            break;                                                                
        case DID_CANCEL:                                                        
            frame->dismiss(DID_CANCEL);                                           
            break;                                                                
        default:
            eventProcessed=false;           
    }
    return(eventProcessed);                                                   
} 
