///////////////////////////////////////////////////////////////////////////////
//                      SAMPLE CODE
//
// FileName: ACDFDlg6.hpp
//
// ClassName: ATextDialog
//
// Description: Conversion of the Hello World 5 Sample
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _ADIALOG6_
#define _ADIALOG6_

#ifdef IC_TRACE_DEVELOP
    #include <itrace.hpp>
#else
    #define IFUNCTRACE_DEVELOP()
    #define ITRACE_DEVELOP(x)
#endif

#include <iframe.hpp>   
#include <icmdhdr.hpp>  
#include <istring.hpp>  
#include <imcelcv.hpp>  
#include <istattxt.hpp> 
#include <ientryfd.hpp> 
#include <isetcv.hpp>   
#include <ipushbut.hpp> 

//Forward declarations for other classes:
class ATextDialog;                                                         

class ADialogCommandHandler : public ICommandHandler 
{                     
public:                                                                    
                            ADialogCommandHandler(ATextDialog *dialogFrame);

  virtual                   ~ADialogCommandHandler() { }


protected:

    virtual Boolean         command(ICommandEvent& cmdEvent);

private:                                                                   
            ATextDialog     *frame;
};

class ATextDialog : public IFrameWindow                                    
{                                                                          
public:

                            ATextDialog(IString & textString,IWindow * ownerWnd);

    virtual                 ~ATextDialog();               

    virtual ATextDialog     &setTextFromEntryField();                                               

private:                                                                 
    IString                 &saveText;
    IMultiCellCanvas        clientCanvas;
    IStaticText             statText;
    IEntryField             textField;
    ISetCanvas              buttons;
    IPushButton             pushButton1,
                            pushButton2;                                  
    ADialogCommandHandler   dialogCommandHandler;
    ATextDialog             &operator=(const ATextDialog&);  
};                                                                         

#endif                                                                     
        
