///////////////////////////////////////////////////////////////////////////////
//                      SAMPLE CODE
//
// FileName: ACDFEat6.hpp
//
// ClassName: AEartWindow
//
// Description: Conversion of the Hello World 5 Sample
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _AEARTHW6_
#define _AEARTHW6_

#ifdef IC_TRACE_DEVELOP
    #include <itrace.hpp>
#else
    #define IFUNCTRACE_DEVELOP()
    #define ITRACE_DEVELOP(x)
#endif

// Open Class 2D Drawing Section 
#include <igline.hpp>
#include <igelipse.hpp>
#include <igrect.hpp>
#include <igbundle.hpp>
#include <idrawcv.hpp>
#include <iglist.hpp>
#include <isizehdr.hpp>

const int                       //Number of stars in the sky
  stars=13;
const int                       //Number of layers in the atmosphere
  atmosphereLayers=3;

class AEarthWindow;
// Class Star -- Draws a star at a specified location


class Star:public IGLine 
{
public:
                            Star(const IPoint &pt) ;

                  Star      &setPoint(const IPoint &pt);
};



// Class AEarthWindowResizeHandler -- A handler to resize the picture 
//  according to the new dimensions of the IDrawingCanvas window.

class AEarthWindowResizeHandler: public IResizeHandler
{
public:
                            AEarthWindowResizeHandler (AEarthWindow *aew);

     virtual                ~AEarthWindowResizeHandler();

protected:
//The windowResize() function is called to handle resizing of
//the IDrawingCanvas text window containing the graphics of Earth.
    virtual     Boolean windowResize(IResizeEvent & evnt);

private:
            AEarthWindow    *earthWindow;
};

//Class AEarthWindow -- Earth window for the C++ Hello World sample application.

class AEarthWindow : public IDrawingCanvas
{                                                                           
public:
                            AEarthWindow(unsigned long windowId,
                                    IWindow * parentownerWindow,                               
                                    const IRectangle& rect=IRectangle());                      

    virtual                 ~AEarthWindow();
                        
            Boolean         paintWorld(),
                            paintStars();

private:
  AEarthWindow              &operator=(const AEarthWindow&);//Default assignment operator

  AEarthWindowResizeHandler earthWindowResizeHandler;
  IColor                    spaceColor,
                            globeColor,
                            starColor;
  Star                      *starlist[stars];
  IGEllipse                 *earthArc[atmosphereLayers+1];
  IGRectangle               space;
  IGList                    graphList,
                            earthGraphicList,
                            starGraphicList;
};
#endif

