///////////////////////////////////////////////////////////////////////////////
//                                              SAMPLE CODE
//
// FileName: ACDFMdl6.cpp
//
// ClassName: ACompDocFwkModel
//
// Description: Conversion of the Hello World 5 Sample
//
///////////////////////////////////////////////////////////////////////////////
#include "ACDFMdl6.hpp"
#include "ACDFVw6.hpp"
#include "acdfst6.hpp"
#include <imsgbox.hpp>

#include <fstream.h>
#include <inotifev.hpp>
#include <ibasstrm.hpp>
#include <iStatnry.hpp>
#include <iexcept.hpp>
#include <icconst.h>
#include <assert.h>
#include <iframe.hpp>

TypeExtensionMacro(ACompDocFwkModel)

ACompDocFwkModel::ACompDocFwkModel()  
// Default Constructor
{       IFUNCTRACE_DEVELOP();}

ACompDocFwkModel::~ACompDocFwkModel()
// Default Destructor
{       IFUNCTRACE_DEVELOP();}

ACompDocFwkModel::ACompDocFwkModel( const ACompDocFwkModel& other ) :
            IModel( other ) // force assert
// Copy Constructor
{       IFUNCTRACE_DEVELOP(); }


IBaseStream& ACompDocFwkModel::operator>>=(IBaseStream& toWhere) const
// Stream member data out
{       IFUNCTRACE_DEVELOP();
    writeVersion(toWhere, kOriginalVersion);
    IModel::operator>>=( toWhere );
    return toWhere;
}

IBaseStream& ACompDocFwkModel::operator<<=(IBaseStream& fromWhere)
// Stream member data in
{       IFUNCTRACE_DEVELOP();
    switch (readVersion(fromWhere))
    {
        case kOriginalVersion:
            IModel::operator<<=( fromWhere );
            break;
        default:
        ITHROWLIBRARYERROR(IC_STREAM_VERSION_UNSUPPORTED, 
              IBaseErrorInfo::invalidRequest,
              IException::recoverable);
    }
    return fromWhere;
}
// IComponent Stationery class is created using the model, view

ACompDocFwkMyStationery CompDocFwkStationery;


int main( int argc, char* argv[] )
{
    int ireturn;
    try
    {
        // Stationery run will eventually call the IApplication::current().run()
        ireturn =  CompDocFwkStationery.run( argc, argv );
    }

    catch (IException& exc)
    {
        ofstream  errorFile("errormsg.log",ios::app);
        const IExceptionLocation *excLocate = exc.locationAtIndex(0);

        errorFile << "Exception on exit " << exc.text() << endl;
        errorFile << "File : " << excLocate->fileName() << endl;
        errorFile << "Function : " << excLocate->functionName() << endl;
        errorFile << "Line : " << excLocate->lineNumber() << endl;

        cout << "Exception on exit " << exc.text() << endl;
        cout << "File : " << excLocate->fileName() << endl;
        cout << "Function : " << excLocate->functionName() << endl;
        cout << "Line : " << excLocate->lineNumber() << endl;
    }
    return ireturn;
}
    
