///////////////////////////////////////////////////////////////////////////////
//                                              SAMPLE CODE
//
// FileName: ACDFVw6.cpp
//
// ClassName: ACompDocFwkView
//
// Description: Conversion of the Hello World 5 Sample
//
///////////////////////////////////////////////////////////////////////////////
#include "ACDFMdl6.hpp"
#include "ACDFVw6.hpp"
#include "acdfbd6.hpp"
#include "acdfdlg6.hpp"

#include <igstring.hpp>
#include <igrect.hpp>
#include <igrafctx.hpp>
#include <imsgbox.hpp>
#include <ifont.hpp>
#include <imenubar.hpp>
#include <iframe.hpp>  // must be included to set the icon
#include "acdfres6.h"

#include <iGUIBndl.hpp> // must be include after windows.h

ACompDocFwkView::ACompDocFwkView(IGUIBundle& bundle ) :
    IView(bundle),
    clientWindow(WND_CANVAS,
                this,
                this),
    helloCanvas(WND_HCANVAS, 
                &clientWindow,
                &clientWindow,
                IRectangle(),
                IWindow::visible |
                ISplitCanvas::horizontal),
    hello(WND_HELLO,
                &helloCanvas,
                &helloCanvas),
    earthWindow(WND_EARTH,  
                &helloCanvas  ),
    listBox(WND_LISTBOX,
                &clientWindow,
                &clientWindow,
                IRectangle(),
                IListBox::defaultStyle() |
                IControl::tabStop |
                IListBox::noAdjustPosition),
    fCommandHandler(*this, handleCommand),
    fSelectHandler(*this),
    fHelpHandler(*this)
    // Constructor
{   IFUNCTRACE_DEVELOP();
    bundle.frameWindow().setIcon(IC_ACDF6);
    bundle.frameWindow().setId(WND_MAIN);
}

ACompDocFwkView::~ACompDocFwkView()
// Destructor
{   IFUNCTRACE_DEVELOP(); 
    fCommandHandler.stopHandlingEventsFor(this);
    fSelectHandler.stopHandlingEventsFor(&listBox);
    fHelpHandler.stopHandlingEventsFor(&bundle().frameWindow());
}

void ACompDocFwkView::initialize()
// Intialize code e.g build menus
{   IFUNCTRACE_DEVELOP();
    IView::initialize();
    bundle().objectView().setBackgroundColor(IColor(64,128,128)); // Set the color to green

    this->sizeTo(ISize(400,300));
    
    //Get the frame window handle from the bundle

    setViewClient(&clientWindow);

    clientWindow.setSplitWindowPercentage(&helloCanvas, 60);
    clientWindow.setSplitWindowPercentage(&listBox, 40);

    for (int i=0;i<=HI_COUNT;i++)
    {
        listBox.addAscending(HI_WORLD+i);
    }

    hello.setText(STR_HELLO);
    fSelectHandler.handleEventsFor(&listBox);

    fCommandHandler.handleEventsFor(this);
    fHelpHandler.handleEventsFor(&bundle().frameWindow());
    setTextAlignment(center);
}


void ACompDocFwkView::drawContents( IPresSpaceHandle& hdl,
                  const IRectangle& invalidArea,
                  Boolean metaFile )
//  We can override "drawContents" if we want to optimize our drawing
//  or do things differently when rendering to a meta-file (where controls
//  won't be displayed).
{   IFUNCTRACE_DEVELOP();
    if (metaFile)
    {
    // Place the embedded image format here !!!
       IGString myText(hello.text(),IPoint(20,10));
       IGRectangle myRect(IRectangle(IPoint(10,10), IPoint(250,40)));
       IGraphicContext ctxt ( hdl );
       ctxt.setFillColor(IColor::white);
       myRect.drawOn(ctxt);
       myText.drawOn(ctxt);

    }
}

Boolean ACompDocFwkView::handleCommand(ICommandEvent& cmdEvent)
// Handle all the menu and push button commands
{   IFUNCTRACE_DEVELOP();

    Boolean eventProcessed(true);
    switch (cmdEvent.commandId())
    {
        case MI_CENTER:
        {
            setTextAlignment(ACompDocFwkView::center);
            break;
        }
        case MI_LEFT:
        {
            setTextAlignment(ACompDocFwkView::left);
            break;
        }
        case MI_RIGHT:
        {
            setTextAlignment(ACompDocFwkView::right);
            break;
        }
        case MI_TEXT:
        {
            editText();
            break;
        }
        default:
        {
            eventProcessed = false;
            break;
        }
    }
    return eventProcessed;
}

Boolean ACompDocFwkView::handleSelected(IControlEvent& event)
// Handle all the selections List Box
{   IFUNCTRACE_DEVELOP();

    Boolean eventProcessed = false;

    if (event.controlId() == WND_LISTBOX)
    {
        setTextFromListBox();
        eventProcessed = true;
    }
    return eventProcessed;
}
Boolean ACompDocFwkView::handleKeysHelpId(IEvent& event)
// Handle the keys help request event
{   IFUNCTRACE_DEVELOP();

    event.setResult(1000);  // 1000 = keys help ID

    return true;
} 

ACompDocFwkView& ACompDocFwkView::setTextAlignment(const Alignment alignment)
//align static text in client window
{   IFUNCTRACE_DEVELOP();

    IMenuBar& myMenuBar = bundle().objectMenuBar();
    ACompDocFwkMyBundle* myBundle = (ACompDocFwkMyBundle*) &bundle();
    switch(alignment)
    {
        case left:
        {       
            hello.setAlignment(IStaticText::centerLeft);
            myBundle->statusLine()->setText(STR_LEFT);
            myMenuBar.uncheckItem(MI_CENTER);
            myMenuBar.checkItem(MI_LEFT);
            myMenuBar.uncheckItem(MI_RIGHT);
            break;
        }
        case center:
        {       
            hello.setAlignment(IStaticText::centerCenter);
            myBundle->statusLine()->setText(STR_CENTER);
            myMenuBar.checkItem(MI_CENTER);
            myMenuBar.uncheckItem(MI_LEFT);
            myMenuBar.uncheckItem(MI_RIGHT);
            break;
        }
        case right:
        {       
            hello.setAlignment(IStaticText::centerRight);
            myBundle->statusLine()->setText(STR_RIGHT);
            myMenuBar.uncheckItem(MI_CENTER);
            myMenuBar.uncheckItem(MI_LEFT);
            myMenuBar.checkItem(MI_RIGHT);
            break;
        }
    }
    return (*this);
}

ACompDocFwkView& ACompDocFwkView::editText()
// Creates and shows a dialog window for inputting text
// that will be used to replace the text string
{   IFUNCTRACE_DEVELOP();

    IString textValue(hello.text());
    ACompDocFwkMyBundle* myBundle = (ACompDocFwkMyBundle*) &bundle();

    myBundle->infoArea()->setInactiveText(STR_INFODLG);
    ATextDialog textDialog(textValue,this);
    myBundle->helpWindow()->setAssociatedWindow(&textDialog);
    textDialog.showModally();

    if (textDialog.result() == DID_OK)
    {
        hello.setText(textValue);
    }

    myBundle->infoArea()->setInactiveText(STR_INFO);

    return (*this);
}

ACompDocFwkView& ACompDocFwkView::setTextFromListBox()
// Set the hello world text from the first selected item in the 
// AHelloWindow listbox.
{   IFUNCTRACE_DEVELOP();
    IListBox::Cursor lbCursor(listBox);

    lbCursor.setToFirst();
    hello.setText(listBox.elementAt(lbCursor));

    return (*this);
}
