///////////////////////////////////////////////////////////////////////////////
//                      SAMPLE CODE
//
// FileName: ACDFVw6.hpp
//
// ClassName: ACompDocFwkView
//
// Description: Conversion of the Hello World 5 Sample
//
///////////////////////////////////////////////////////////////////////////////
#ifndef _COMPDOCFWKVIEW_
#define _COMPDOCFWKVIEW_

#ifdef IC_TRACE_DEVELOP
    #include <itrace.hpp>
#else
    #define IFUNCTRACE_DEVELOP()
    #define ITRACE_DEVELOP(x)
#endif

#include <ithlphdr.hpp>
#include <iview.hpp>
#include <ipushbut.hpp>
#include <iinfoa.hpp>
#include <icmdhdr.hpp>
#include <isetcv.hpp>
#include <istattxt.hpp>
#include <ilistbox.hpp>
#include <itselhdr.hpp>
#include <isplitcv.hpp>
#include <ithlphdr.hpp>
#include <ihelp.hpp>
#include <ihandler.hpp>

#include "acdfeat6.hpp"

class IFrameWindow;
class ACompDocFwkModel;
class ACompDocFwkView;

class ACompDocFwkView : public IView
{
public:
    enum Alignment          {left, center, right };

                            ACompDocFwkView(IGUIBundle& );
    virtual                 ~ACompDocFwkView();

    virtual void            initialize();

    virtual void            drawContents( IPresSpaceHandle&,
                                          const IRectangle& invalidArea,
                                          Boolean metaFile );

    virtual Boolean         handleCommand(ICommandEvent&);
    virtual Boolean         handleSelected(IControlEvent&);
    virtual Boolean         handleKeysHelpId(IEvent&);

    virtual ACompDocFwkView &setTextAlignment(const Alignment alignment);
    virtual ACompDocFwkView &editText();
    virtual ACompDocFwkView &setTextFromListBox();
    
protected:
                            ACompDocFwkView(const ACompDocFwkView&);

private:
    ACompDocFwkView&        operator=( const ACompDocFwkView& );

    ISplitCanvas            clientWindow,
                            helloCanvas;
    IStaticText             hello;
    AEarthWindow            earthWindow;
    IListBox                listBox;

    IHelpConnectionTo<ACompDocFwkView>      fHelpHandler;

    ICommandConnectionTo<ACompDocFwkView>   fCommandHandler;
    ISelectConnectionTo<ACompDocFwkView>    fSelectHandler;
};

#endif
    
