// SelectHdr.hpp

#ifndef _SELECTHDR_
#define _SELECTHDR_

#include <iselhdr.hpp>

template <class ATarget>
class ISelectConnectionTo : public ISelectHandler {
public:
                        ISelectConnectionTo( ATarget& );
    virtual             ~ISelectConnectionTo();
    
protected:
	virtual Boolean 	selected( IControlEvent& event );
    
private:
    ATarget&            fTarget;
};

template<class ATarget>
inline
ISelectConnectionTo<ATarget>::ISelectConnectionTo( ATarget& t )
: fTarget(t)
{
}

template<class ATarget>
ISelectConnectionTo<ATarget>::~ISelectConnectionTo()
{
}

    
template<class ATarget>
Boolean
ISelectConnectionTo<ATarget>::selected( IControlEvent& event )
{
    return fTarget.handleSelected( event );
}
    
#endif
