/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

// animal.h  -  Class Animal for use with the example animals.C


  #include <iglobals.h>           // For definition of Boolean:
  #include <istring.hpp>          // Class IString:
  #include <iostream.h>

class Animal {
  IString nm;
  IString attr;

public:

  Animal(IString n, IString a) : nm(n), attr(a)  {}

  // For copy constructor we use the compiler generated default.

  // For assignment we use the compiler generated default.

  IBoolean operator==(Animal const& p) const  {
     return  ((nm == p.name()) && (attr == p.attribute()));
  }

  IString const& name() const {
     return nm;
  }

  IString const& attribute() const {
     return attr;
  }

  friend ostream& operator<<(ostream& os, Animal const& p)  {
     return os << "The " << p.name() << " is " << p.attribute()
     << "." << endl;
  }

};

  // Key access:
inline IString const& key(Animal const& p)  {
  return p.name();
}

  // We need a hash function for the key type as well.
  // Let's just use the default provided for IString.
inline unsigned long hash(Animal const& animal, unsigned long n) {
  return hash(animal.name(), n);
}
