/******************************************************************************
* .FILE:         aclient.hpp                                                  *
*                                                                             *
* .DESCRIPTION:  Dynamic Data Exchange Client Program: Class Definitions      *
*                                                                             *
* .CLASSES:      AClientWindow                                                *
*                AConversation                                                *
*                                                                             *
* .COPYRIGHT:                                                                 *
*    Licensed Material - Program-Property of IBM                              *
*    (C) Copyright IBM Corp. 1992, 1996 - All Rights Reserved                 *
*                                                                             *
* .DISCLAIMER:                                                                *
*   The following [enclosed] code is sample code created by IBM               *
*   Corporation.  This sample code is not part of any standard IBM product    *
*   and is provided to you solely for the purpose of assisting you in the     *
*   development of your applications.  The code is provided 'AS IS',          *
*   without warranty of any kind.  IBM shall not be liable for any damages    *
*   arising out of your use of the sample code, even if they have been        *
*   advised of the possibility of such damages.                               *
*                                                                             *
* .NOTE: WE RECOMMEND USING A FIXED SPACE FONT TO LOOK AT THE SOURCE          *
*                                                                             *
******************************************************************************/
#ifndef ACLIENTWINDOW_HPP
#define ACLIENTWINDOW_HPP

#include <iframe.hpp>                             //IFrameWindow
#include <icmdhdr.hpp>                            //ICommandHandler
#include <iddetsrv.hpp>                           //IDDEServer Classes
#include <iddeccnv.hpp>
#include <ireslib.hpp>

class IMenuBar;
class ISplitCanvas;
class IStaticText;
class IInfoArea;
class AConversation;

/**********************************************************/
/* Define our Customer DDE Client Window                  */
/**********************************************************/
class AClientWindow : public IFrameWindow, public ICommandHandler
{
public:
  AClientWindow     (unsigned long windowId);     //Constructor
  ~AClientWindow    ();                           //Destructor
  virtual Boolean   log(const char *);            //Log message to window
  virtual Boolean   log(IResourceId id);          //Log message to window
  virtual Boolean   setWorkItem(char * message);  //Set new work item
  virtual IString   workItem();                   //Get work item
  virtual Boolean   workItemDone();               //Set work item done
  virtual Boolean   updateStatus();               //Update status line
  virtual Boolean   updateTodo(char * newCount);  //Update todo count
  virtual Boolean   updateWork(char * newCount);  //Update work count
  virtual Boolean   updateDone(char * newCount);  //Update done count

protected:
  virtual Boolean   command(ICommandEvent& cmdevt);

private:
  IMenuBar          menuBar;                      //Menu Bar
  ISplitCanvas      statusLine;                   //Status line
  IStaticText       todoStatus;                   //Todo list status
  IStaticText       workStatus;                   //Work list status
  IStaticText       doneStatus;                   //Done list status
  ISplitCanvas      cArea;                        //Client area canvas
  IStaticText       workWindow;                   //Work static window
  IMultiLineEdit    mle;                          //MLE to log status
  IInfoArea         infoArea;                     //Information Area
  AConversation *   conversation;
  long              todoCount;
  long              workCount;
  long              doneCount;
  IResourceLibrary  resLib;
};

class AConversation : public IDDEClientConversation
{
public:

  AConversation(AClientWindow* frameWin);

  void              conversationEnded(IDDEClientEndEvent& conv);
  void              acknowledged(IDDEClientAcknowledgeEvent& event);
  Boolean           data(IDDEDataEvent& event);
  AClientWindow *   mainWindow() { return clientWindow; }

private:
  AClientWindow *   clientWindow;
  IResourceLibrary  resLib;
};  // end AConversation
#endif
