/******************************************************************************
* .FILE:         aserver.hpp                                                  *
*                                                                             *
* .DESCRIPTION:  Dynamic Data Exchange Server Program: Class Definitions      *
*                                                                             *
* .CLASSES:      AServerWindow                                                *
*                ATopicServer                                                 *
*                                                                             *
* .COPYRIGHT:                                                                 *
*    Licensed Material - Program-Property of IBM                              *
*    (C) Copyright IBM Corp. 1992, 1996 - All Rights Reserved                 *
*                                                                             *
* .DISCLAIMER:                                                                *
*   The following [enclosed] code is sample code created by IBM               *
*   Corporation.  This sample code is not part of any standard IBM product    *
*   and is provided to you solely for the purpose of assisting you in the     *
*   development of your applications.  The code is provided 'AS IS',          *
*   without warranty of any kind.  IBM shall not be liable for any damages    *
*   arising out of your use of the sample code, even if they have been        *
*   advised of the possibility of such damages.                               *
*                                                                             *
* .NOTE: WE RECOMMEND USING A FIXED SPACE FONT TO LOOK AT THE SOURCE          *
*                                                                             *
******************************************************************************/
#ifndef ASERVERWINDOW_HPP
#define ASERVERWINDOW_HPP

#include <iframe.hpp>                             //IFrameWindow
#include <iddetsrv.hpp>                           //IDDEServer Classes
#include <ireslib.hpp>

class ISplitCanvas;
class IStaticText;
class IListBox;
class IMultiLineEdit;
class IInfoArea;
class AServerWindow;

class ATopicServer : public IDDETopicServer {
public:
  ATopicServer(const char* app,                   //ATopicServer Constructor
          const char* topic,
          AServerWindow* mainWin) ;

  Boolean           acceptConversation(           //Start conversation
                      unsigned long conversationId,
                      IDDEBeginEvent& event);
  Boolean           beginHotLink(
                       unsigned long conversationId,
                       IDDEServerHotLinkEvent& event);
  Boolean           pokeData(                     //Poke Data
                      unsigned long conversationId,
                      IDDEPokeEvent& event);
  Boolean           requestData(                  //Client requesting data
                      unsigned long conversationId,
                      IDDERequestDataEvent& event);
  void              requestHotLinkData(           //Client requesting hot link
                      IDDERequestDataEvent& event);
  void              hotLinkEnded(
                      unsigned long conversationId,
                      IDDEEvent& event);
  void              conversationEnded(           //End conversation
                      unsigned long conversationId,
                      IDDEEndEvent& conv);

  AServerWindow *   mainWindow() const { return serverWindow;}

private:
  AServerWindow *   serverWindow;
  IResourceLibrary  resLib;                       //Resource library
}; /* End of ATopicServer */

/**********************************************************/
/* Define our DDE Server Active conversation Window       */
/**********************************************************/
class AServerWindow : public IFrameWindow
{
public:
  AServerWindow     (unsigned long windowId);     //Constructor
  virtual Boolean   log(char * message);          //Log message to window
  virtual Boolean   log(IResourceId id);          //Log message to window
  virtual Boolean   addDone(char * newDone);      //Add item to done list
  virtual Boolean   addTodo(IResourceId id);      //Add item to todo list
  virtual Boolean   moreTodo();                   //Add more to todo list
  virtual Boolean   addHot();                     //Set hot link active flag
  virtual Boolean   removeHot();                  //Set hot link active flag
  virtual IString   nextTodo();                   //Get next todo
  virtual IString   todo();                       //Get todo count
  virtual IString   work();                       //Get work count
  virtual IString   done();                       //Get done count
  virtual Boolean   updateStatus();               //Update status line

private:
  ISplitCanvas      statusLine;                   //Status line
  IStaticText       todoStatus;                   //Todo list status
  IStaticText       workStatus;                   //Work list status
  IStaticText       doneStatus;                   //Done list status
  ISplitCanvas      cArea;                        //Client area canvas
  ISplitCanvas      dArea;                        //Data area canvas
  IListBox          todoList;                     //Todo list
  IListBox          workList;                     //Work list
  IListBox          doneList;                     //Done list
  IMultiLineEdit    mle;                          //MLE to log status
  IInfoArea         infoArea;                     //Information Area
  int               hot;                          //true=hot link active
  IResourceLibrary  resLib;                       //Resource library
  ATopicServer      server;                       //DDE Topic Server
}; /* End of AServerWindow */

#endif
