/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

/*--------------------------------------------------------------*\
|                                                                |
|  evenodd.CPP  -  Even and Odd numbers are handled in different |
|                  Sets do demonstrate using Sets.               |
|                                            """                 |
\*--------------------------------------------------------------*/

#include <iostream.h>

#include <iset.h>        // Take the defaults for the Set and for
                         // the required functions for integer
typedef ISet <int> IntSet;

/*-------------------------------------------------------------*\
| For iteration we want to use an object of an iterator class   |
\*-------------------------------------------------------------*/
class PrintClass : public IIterator<int>  {
  public:
    virtual IBoolean applyTo(int& i)
      { cout << " " << i << " "; return True;}
};


/*-------------------------------------------------------------*\
| Local prototype for the function to display an IntSet.        |
\*-------------------------------------------------------------*/
void    List(char *, IntSet &);


/*-------------------------------------------------------------*\
| Main program                                                  |
\*-------------------------------------------------------------*/
int main ()  {
   IntSet odd, prime;
   IntSet oddPrime, evenPrime;

   int One = 1, Two = 2, Three = 3, Five = 5, Seven = 7, Nine = 9;

// Fill odd set with odd integers < 10
   odd.add( One );
   odd.add( Three );
   odd.add( Five );
   odd.add( Seven );
   odd.add( Nine );
   List("Odds less than 10:  ", odd);

// Fill prime set with primes < 10
   prime.add( Two );
   prime.add( Three );
   prime.add( Five );
   prime.add( Seven );
   List("Primes less than 10:  ", prime);

// Intersect 'Odd' and 'Prime' to give 'OddPrime'
   oddPrime.addIntersection( odd, prime);
   List("Odd primes less than 10:  ", oddPrime);

// Subtract all 'Odd' from 'Prime' to give 'EvenPrime'
   evenPrime.addDifference( prime, oddPrime);
   List("Even primes less than 10:  ", evenPrime);

   return(0);
}

/*-------------------------------------------------------------*\
| Local function to display an IntSet.                          |
\*-------------------------------------------------------------*/

void List(char *Message, IntSet &anIntSet)  {
   PrintClass Print;

   cout << Message;
   anIntSet.allElementsDo(Print);
   cout << endl;
}

