/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#include <istring.hpp>

class Circle : public Graphics
{
public:

  float ivXCenter;
  float ivYCenter;
  float ivRadius;


  Circle(int graphicsKey, IString id ,
         double xCenter, double yCenter,
         double radius)
                          : Graphics(graphicsKey, id),
                            ivXCenter(xCenter),
                            ivYCenter(yCenter),
                            ivRadius(radius)
                            { }


  IBoolean operator== (Circle const& circle) const
    {
     return (this->ivXCenter == circle.ivXCenter &&
             this->ivYCenter == circle.ivYCenter &&
             this->ivRadius == circle.ivRadius);
    }


  void          draw() const
    {
     cout << "drawing "
          << Graphics::id()
          << endl
          << "with center: "
          << "(" << this->ivXCenter << "|"
          << this->ivYCenter << ")"
          << " and with radius: "
          << this->ivRadius
          << endl;
    }


  void          circumference() const
    {
     cout << "The circumference of "
          << Graphics::id()
          << " is: "
          << ((this->ivRadius)*2*3.14)
          << endl;
    }

};
