/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#include <istring.hpp>
#include <iostream.h>


class Graphics
{

protected:


  IString ivId;    //*** graphics ID ****/
  int     ivKey;   //*** graphics key ****/

public:


  Graphics (int graphicsKey, IString id) : ivKey(graphicsKey),
                                           ivId(id)
                                           { }


  ~Graphics()
    {
     cout << this->ivId
           << " will now be deleted ... "
          << endl;
    }


  IBoolean operator== (Graphics const& graphics) const
    {
     return (this->ivId == graphics.ivId);
    }


  IString const& id() const
    {
     return ivId;
    }


  virtual        void           draw() const =0;

  /**** This member function returns the graphic's key ****/
  /*    Note that we are returning the int by reference,  */
  /*    because this member function will be used by the  */
  /*    key(...) function, which must return a reference. */
  /********************************************************/
  int const& graphicsKey() const
    {
     return ivKey;
    }

};

/****************       key function       *********************/
/****   note that this interface must always be used with:  ****/
/****              Keytype const& key(....)                 ****/
/****                                                       ****/
/****   We are providing this key function for the element  ****/
/****   type Graphics  and not for the managed pointer.     ****/
/***************************************************************/
  inline int const& key (Graphics const& graphics)
    {
     return graphics.graphicsKey();
    }
