/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

#include <istring.hpp>
#include <math.h>


class Line : public Graphics
{
public:

  double ivXStart;
  double ivYStart;
  double ivXEnd;
  double ivYEnd;


  Line(int graphicsKey, IString id, double xstart, double ystart,
                                    double xend,   double yend)

                                  : Graphics(graphicsKey, id),
                                    ivXStart(xstart),
                                    ivYStart(ystart),
                                    ivXEnd(xend),
                                    ivYEnd(yend)
                                    { }


  IBoolean operator== (Line const& line) const
    {
     return (this->ivXStart == line.ivXStart &&
             this->ivYStart == line.ivYStart &&
             this->ivXEnd == line.ivXEnd &&
             this->ivYEnd == line.ivYEnd);
    }


  void           draw() const
    {
     cout << "drawing "
          << Graphics::id()
          << endl
          << "with starting point: "
          << "(" << this->ivXStart
          << "|" << this->ivYStart << ")"
          << " and with ending point: "
          << "(" << this->ivXEnd
          << "|" << this->ivYEnd << ")"
          << endl;
    }


  void           lengthOfLine() const
    {
     cout << "The length of line "
          << Graphics::id()
          << " is: "
          << sqrt(pow(((this->ivXEnd) - (this->ivXStart)),2)
                + pow(((this->ivYEnd) - (this->ivYStart)),2))
          << endl;
    }

};
