/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

/*-------------------------------------------------------------*\
|  demoelem.h  -  DemoElement for use with Key Collections      |
\*-------------------------------------------------------------*/
#ifndef _DEMOELEM_H
#define _DEMOELEM_H

#include <stdlib.h>
#include <iglobals.h>
#include <iostream.h>
#include <istdops.h>

class DemoElement {

  int i;
  int j;

public:

           DemoElement ()
           : i(0), j(0)
           {
           }

           DemoElement (int i,int j)
           : i (i), j(j)
           {
           }

           operator int () const
           { return i;
           }

  IBoolean operator == (DemoElement const& k) const
           { return i == k.i && j == k.j;
           }

  IBoolean operator < (DemoElement const& k) const
           { return i < k.i || (i == k.i && j < k.j);
           }

  friend unsigned long
           hash (DemoElement const& k, unsigned long n)
           { return k.i % n;
           }

  int const &
           geti () const
           { return i;
           }

  int const &
           getj () const
           { return j;
           }

};

inline ostream & operator << (ostream &sout, DemoElement const& e)
{ sout << e.geti () << "," << e.getj ();
  return sout;
}

inline int const& key (DemoElement const& k)
{ return k.geti ();
}

// NOTE: You must return a const & in the key function!
// Otherwise the implicitly created standard element operations
// will return a reference to a temporary. This would lead to
// incorrect behavior of the collection operations.

// The key function must be declared in the header file of
// the collection's element type.

// If either of these is not possible or undesirable,
// an element operations class must be used.

#endif
