/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

/*-------------------------------------------------------------*\
|  intkyset.CPP  -  Integer Key Set for demonstration of using  |
|                   a KeySet.                                   |
\*-------------------------------------------------------------*/
#include <iostream.h>
#include <iglobals.h>

#include <iks.h>
                      // Class DemoElement:
#include "demoelem.h"

typedef IKeySet < DemoElement,int > TestKeySet;

ostream & operator << ( ostream & sout, TestKeySet const & t)
{ sout << t.numberOfElements() << " elements are in the set:" << endl;

  TestKeySet::Cursor cursor (t);

  //  forICursor(c)
  // expands to
  //  for ((c).setToFirst (); (c).isValid (); (c).setToNext ())

  forICursor (cursor)
    sout << "   " << cursor.element () << endl;

  return sout << endl;
}


main()
{
  TestKeySet t;

  t.add(DemoElement(1,1));
  t.add(DemoElement(2,4711));
  t.add(DemoElement(3,1));
  t.add(DemoElement(4,443));

  cout << t;

  t.removeElementWithKey (3);

  cout << t;

  return 0;
}
