/******************************************************************************
* .FILE:         lancelot.cpp                                                 *
*                                                                             *
* .DESCRIPTION:  Lancelot Sample Program:              Class Implementation   *
*                                                                             *
* .CLASSES:      None                                                         *
*                                                                             *
* .COPYRIGHT:                                                                 *
*                                                                             *
* .DISCLAIMER:                                                                *
*                                                                             *
* .NOTE: WE RECOMMEND USING A FIXED SPACE FONT TO LOOK AT THE SOURCE          *
*                                                                             *
******************************************************************************/

#ifndef _IBASE_                         //Make sure ibase.hpp is included
  #include <ibase.hpp>                  //  since that is where IC_<environ>
#endif                                  //  is defined.
#include <iapp.hpp>
#include <ithread.hpp>
#include <imsgbox.hpp>
#include <icoordsy.hpp>
#include "lmainwin.hpp"

int main()
{
  ICoordinateSystem::setApplicationOrientation(
          ICoordinateSystem::originLowerLeft );

/*-----------------------------------------------------------------------------
| Set the default IHelpWindow style for the entire application.               |
| If USE_IPF is defined, use IPF help.  Otherwise, use Windows RTF help.      |
-----------------------------------------------------------------------------*/
   #if (defined IC_WIN && defined USE_IPF)
   IHelpWindow::setDefaultStyle( IHelpWindow::defaultStyle()
                                 | IHelpWindow::ipfCompatible );
   #endif

/*-----------------------------------------------------------------------------
| Set the default IToolBarButton styles for the entire application.           |
-----------------------------------------------------------------------------*/
   #ifndef IC_MOTIF
   IToolBarButton::setDefaultStyle(
     IToolBarButton::classDefaultStyle
     &~IToolBarButton::standardFormat );
   #endif

/*-----------------------------------------------------------------------------
| Test if .INI files can be accessed from the current directory.              |
|   If they can't, tell the user and end the application.                     |
| Create the main window for the application                                  |
| Start the event processing loop                                             |
-----------------------------------------------------------------------------*/
   try
   {
      IProfile testing( "lsaveqry.ini" );
   }
   catch(...)
   {
      IMessageBox
         msgBox( IWindow::desktopWindow() );
      msgBox.show( STR_NO_DB_ACCESS, IMessageBox::catastrophic );
      return 2;
   }

   LMainWindow mainWindow;

   IApplication::current().run();

   return 0;
}

