/*******************************************************************************
* FILE NAME: lpagectl.cpp                                                      *
*                                                                              *
* DESCRIPTION: Page buttons, Container buttons, range combobox.                *
*              These are generic page controls                                 *
*                                                                              *
* Class                                                                        *
*    PageButtons                                                               *
*    PageCnr                                                                   *
*    PageScroll                                                                *
*    PageCnrSelHandler                                                         *
*    QueryRange                                                                *
*                                                                              *
* COPYRIGHT:                                                                   *
*   Licensed Materials - Property of IBM                                       *
*   (C) Copyright IBM Corporation 1992, 1996                                   *
*   All Rights Reserved                                                        *
*   US Government Users Restricted Rights - Use, duplication, or disclosure    *
*   restricted by GSA ADP Schedule Contract with IBM Corp.                     *
*                                                                              *
*******************************************************************************/

#ifndef _IBASE_                         //Make sure ibase.hpp is included
  #include <ibase.hpp>                  //  since that is where IC_<environ>
#endif                                  //  is defined.
#include <ireslib.hpp>
#include "lancelot.h"
#include "lpagectl.hpp"
#include "lacct.hpp"
#include "lskill.hpp"
#include "lproject.hpp"
#include "ltask.hpp"

//*****************************************************************************
// Class PageButtons :: PageButtons() contructor
//*****************************************************************************
PageButtons :: PageButtons ( unsigned long windowId,
                             IMultiCellCanvas* parent,
                             IMultiCellCanvas* owner,
                             Boolean aQueryButton )
    : ISetCanvas( windowId, parent, owner )
#ifndef IC_MOTIF
     ,selectHandler( parent )
#endif
{
    if ( aQueryButton )
    {
        queryButton = new AGraphicPushButton( ID_BUTTON_QUERY, this, this,
                                              ID_PAGE_QUERY);
        saveButton = new AGraphicPushButton( ID_BUTTON_SAVE,
                                             this,
                                             this,
                                             ID_PAGE_SAVE);
        undoButton = NULL;
    }
    else
    {
      undoButton = new AGraphicPushButton( ID_BUTTON_UNDO,
                                           this,
                                           this,
                                           ID_PAGE_UNDO);

      queryButton = NULL;
      saveButton  = NULL;
    }

    helpButton = new AGraphicPushButton( ID_BUTTON_HELP,
                                         this,
                                         this,
                                         ID_PAGE_HELP);
#ifndef IC_MOTIF
    gridCheckBox = new ICheckBox( ID_BUTTON_GRID,
                                  this,
                                  this );
    gridCheckBox->setText( ID_BUTTON_GRID );
    selectHandler.handleEventsFor( gridCheckBox );
#endif

    setDeckOrientation( ISetCanvas::horizontal );
}

//*****************************************************************************
// Class PageButtons :: ~PageButtons() destructor
//*****************************************************************************
PageButtons :: ~PageButtons()
{
    delete queryButton;
    delete saveButton;
    delete undoButton;
    delete helpButton;
#ifndef IC_MOTIF
    selectHandler.stopHandlingEventsFor( gridCheckBox );
    delete gridCheckBox;
#endif
}

#ifndef IC_MOTIF
//*****************************************************************************
// CLASS PageButtonsSelectHandler  - constructor
//*****************************************************************************
PageButtonsSelectHandler::PageButtonsSelectHandler( IMultiCellCanvas* pMulticell )
    : ISelectHandler()
     ,theParentMulticell( pMulticell )
{
}

//*****************************************************************************
// CLASS PageButtonsSelectHandler  - destructor
//*****************************************************************************
PageButtonsSelectHandler::~PageButtonsSelectHandler()
{
}

//*****************************************************************************
// CLASS GeneralPage :: selected() - select handler
//*****************************************************************************
IBase :: Boolean PageButtonsSelectHandler::selected(IControlEvent& event)
{
  theParentMulticell->enableGridLines( !( theParentMulticell->hasGridLines() ) );
  return(false);
}
#endif


//*****************************************************************************
// Class PageCnrButtons :: PageCnrButtons() constructor
//*****************************************************************************
PageCnrButtons :: PageCnrButtons( unsigned long windowId,
                                  IWindow* parent,
                                  IWindow* owner,
                                  Boolean noChangeButton )
    : ISetCanvas( windowId, parent, owner )
{
    addButton = new AGraphicPushButton( ID_BUTTON_ADD,
                                        this,
                                        this,
                                        ID_PAGE_ADD);

    if ( !noChangeButton )
    {
        changeButton = new AGraphicPushButton( ID_BUTTON_CHANGE,
                                               this,
                                               this,
                                               ID_PAGE_CHANGE);

    }

   removeButton = new AGraphicPushButton( ID_BUTTON_REMOVE,
                                          this,
                                          this,
                                          ID_PAGE_REMOVE);


   setDeckOrientation( ISetCanvas::vertical );
}

//*****************************************************************************
// Class PageCnrButtons :: ~PageCnrButtons() destructor
//*****************************************************************************
PageCnrButtons :: ~PageCnrButtons()
{
    delete addButton;
    delete changeButton;
    delete removeButton;
}



//*****************************************************************************
// Class PageCnrButtons :: PageScrollButtons()
//*****************************************************************************
PageScrollButtons :: PageScrollButtons( unsigned long windowId,
                                        IWindow* parent,
                                        IWindow* owner )
    : ISetCanvas( windowId, parent, owner )
    , weekEndingText( ID_NO_ITEM, this, this )
    , dateText()
    , prevButton( ID_BUTTON_PREV, this, this,
                  ID_PAGE_PREVIOUS)
    , nextButton( ID_BUTTON_NEXT,  this, this,
                  ID_PAGE_NEXT)
    , displayText()
{
   setPackType(ISetCanvas::even);
   setDeckOrientation( ISetCanvas::horizontal );
}


//*****************************************************************************
// Class PageScrollButtons :: ~PageScrollButtons()
//*****************************************************************************
PageScrollButtons :: ~PageScrollButtons()
{
};


//*****************************************************************************
// Class PageScrollButtons :: setDisplayText() - week ending text string
// Used in TimeCard page.
//*****************************************************************************
PageScrollButtons& PageScrollButtons :: setDisplayText( const char* theStr )
{

   weekEndingText.setText( STR_TCD_WEEK_ENDING_TEXT );
   displayText = theStr;
   displayText += "      ";
   weekEndingText.setText( weekEndingText.text() + displayText );

   return *this;
}


//*****************************************************************************
// Class QuerryRange :: QueryRange()
//*****************************************************************************
QueryRange :: QueryRange( unsigned long windowId,
                          IWindow* parent,
                          IWindow* owner,
                          unsigned long id)
    : IComboBox( id,  parent, owner,
             IRectangle(),
             (IComboBox::classDefaultStyle &
            ~IComboBox::simpleType     |
             IComboBox::readOnlyDropDownType ) |
             IControl::tabStop)
{
   setLimit( DISPLAY_SMALL_RANGE );
   addAsFirst("=");
   addAsLast(">");
   addAsLast("<");
   addAsLast(">=");
   addAsLast("<=");
   setText("=");
}

//*****************************************************************************
// Class QuerryRange :: ~QueryRange()
//*****************************************************************************
QueryRange :: ~QueryRange()
{};


AGraphicPushButton :: AGraphicPushButton( unsigned long id,
                                             IWindow* parent,
                                             IWindow* owner,
                                             unsigned long iconId) :
   IGraphicPushButton( id, parent, owner, IResourceId(iconId), IRectangle(),
        (IGraphicPushButton::classDefaultStyle |
        IControl::tabStop))
{
}

AGraphicPushButton :: ~AGraphicPushButton()
{
}


#ifdef IC_MOTIF
LPictureVerifyHandler :: LPictureVerifyHandler( IWindow* owner,
                           IString pictureString )
          :IPictureVerifyHandler( pictureString )
{
  pOwner = owner;
}


IWindow* LPictureVerifyHandler :: owner()
{
  return pOwner;
}


IBase::Boolean LPictureVerifyHandler :: invalidChange( IEditVerifyEvent& event )
{
  unsigned long resId, msgId;
  switch (event.controlId()) {

// GENERAL PAGE
    case  ID_GEN_EMPLOYEE_ID_EF:
     resId = STR_GEN_EMPLOYEE_ID_TEXT;
     msgId = STR_MSG_ALPHA_NUMERIC;
     break;
    case  ID_GEN_LAST_NAME_EF:
     resId = STR_GEN_LAST_NAME_TEXT;
     msgId = STR_MSG_ALPHA;
     break;
    case  ID_GEN_FIRST_NAME_EF:
     resId = STR_GEN_FIRST_NAME_TEXT;
     msgId = STR_MSG_ALPHA;
     break;
    case  ID_GEN_MIDDLE_INITIAL_EF:
     resId = STR_GEN_MIDDLE_NAME_TEXT;
     msgId = STR_MSG_ALPHA;
     break;
    case  ID_GEN_INT_PHONE_EF:
     resId = STR_GEN_INT_PHONE_TEXT;
     msgId = STR_MSG_PHONE;
     break;
    case  ID_GEN_EXT_PHONE_EF:
     resId = STR_GEN_EXT_PHONE_TEXT;
     msgId = STR_MSG_PHONE;
     break;
    case  ID_GEN_MGR_EMP_ID_EF:
     resId = STR_GEN_MGR_EMP_NUM_TEXT;
     msgId = STR_MSG_ALPHA_NUMERIC;
     break;
    case  ID_GEN_MGR_NAME_EF:
     resId = STR_GEN_MGR_EMP_NAME_TEXT;
     msgId = STR_MSG_ALPHA;
     break;

// BADGE   PAGE
    case ID_BDG_ISSUE_DATE_EF:
     resId = STR_BDG_ISSUE_DATE ;
     msgId = STR_MSG_DATE;
     break;
    case ID_BDG_EXP_DATE_EF:
     resId = STR_BDG_EXP_DATE;
     msgId = STR_MSG_DATE;
     break;

// STATUS  PAGE
    case ID_STA_START_DATE_EF:
     resId = STR_STA_START;
     msgId = STR_MSG_DATE;
     break;
    case ID_STA_END_DATE_EF:
     resId = STR_STA_END;
     msgId = STR_MSG_DATE;
     break;
    case ID_STA_HOURLY_RATE_EF:
     resId = STR_STA_END;
     msgId = STR_MSG_CURRENCY;
     break;

// PROJECT PAGE
    case ID_PRJ_PROJ_EF:
     resId = STR_PRJ_PROJ;
     msgId = STR_MSG_ALPHA_NUMERIC;
     break;

// TASK PAGE
    case ID_TSK_TASK_EF:
     resId = STR_TSK_TASK;
     msgId = STR_MSG_ALPHA_NUMERIC;
     break;

// TIMECARD PAGE
    case ID_TCD_DATE0_EF:
     resId = STR_TCD_DATE;
     msgId = STR_MSG_DATE;
     break;
  }

  IMessageBox messageBox( owner() ) ;
  messageBox.setTitle(IResourceId(resId));
  messageBox.show(IResourceId(msgId), IMessageBox::information);

  event.allowChange( false );
  return false;
}
#endif

/******************************************************************************
* Class PageCnrSelHandler :: PageCnrSelHandler - Constructor for a select     *
*  handler for a notebook page's container.                                   *
*                                                                             *
* Define yourself as a select handler.                                        *
* Set the page pointer in your private data.                                  *
* Set the type of notebook page.                                              *
******************************************************************************/
PageCnrSelHandler::PageCnrSelHandler( AccountPage* page )
     :ISelectHandler(),
      pPage( page ),
      pageType( accountPage )
{
};


PageCnrSelHandler::PageCnrSelHandler( SkillPage* page )
     :ISelectHandler(),
      pPage( page ),
      pageType( skillPage )
{
};


PageCnrSelHandler::PageCnrSelHandler( ProjectPage* page )
     :ISelectHandler(),
      pPage( page ),
      pageType( projectPage )
{
};


PageCnrSelHandler::PageCnrSelHandler( TasksPage* page )
     :ISelectHandler(),
      pPage( page ),
      pageType( taskPage )
{
};


/******************************************************************************
* Class PageCnrSelHandler :: ~PageCnrSelHandler - Destructor for the page's   *
*  container select handler.                                                  *
******************************************************************************/
PageCnrSelHandler::~PageCnrSelHandler()
{
};


/******************************************************************************
* Class PageCnrSelHandler :: selected - Handle the select events.             *
******************************************************************************/
IBase::Boolean PageCnrSelHandler::selected( IControlEvent& event )
{
   IContainerControl* pCnr = (IContainerControl*) event.controlWindow();
   IContainerControl::ObjectCursor
      soc( *pCnr,
          IContainerObject::selected );

   soc.setToFirst();
   if ( soc.isValid() )
   {
      switch ( pageType )
      {
         case accountPage :
         {
            ((AccountPage*)pPage)->fillEntryfields( (AcctCnrObj *) soc.current() );
            break;
         }
         case skillPage :
         {
            ((SkillPage*)pPage)->fillEntryfields( (SkillCnrObj *) soc.current() );
            break;
         }
         case projectPage :
         {
            ((ProjectPage*)pPage)->fillEntryfields( (ProjCnrObj *) soc.current() );
            break;
         }
         case taskPage :
         {
            ((TasksPage*)pPage)->fillEntryfields( (TaskCnrObj *) soc.current() );
            break;
         }
      }
   }

   return false;
}
