/******************************************************************************
* .FILE:         lpagectl.hpp                                                 *
*                                                                             *
* .DESCRIPTION:  Lancelot Sample Program:              Class Definition       *
*                                                                             *
* .CLASSES:      PageButtons                                                  *
*                PageCnrButtons                                               *
*                PageScrollButtons                                            *
*                QueryRange                                                   *
*                AGraphicPushButton                                           *
*                PageCnrSelHandler                                            *
*                LPictureVerifyHandler                                        *
*                                                                             *
* .COPYRIGHT:                                                                 *
*    Licensed Material - Program-Property of IBM                              *
*    (C) Copyright IBM Corp. 1992, 1996 - All Rights Reserved                 *
*                                                                             *
* .DISCLAIMER:                                                                *
*   The following [enclosed] code is sample code created by IBM               *
*   Corporation.  This sample code is not part of any standard IBM product    *
*   and is provided to you solely for the purpose of assisting you in the     *
*   development of your applications.  The code is provided 'AS IS',          *
*   without warranty of any kind.  IBM shall not be liable for any damages    *
*   arising out of your use of the sample code, even if they have been        *
*   advised of the possibility of such damages.                               *
*                                                                             *
* .NOTE: WE RECOMMEND USING A FIXED SPACE FONT TO LOOK AT THE SOURCE          *
*                                                                             *
******************************************************************************/
#ifndef _LPAGECTL_
#define _LPAGECTL_

#include <isetcv.hpp>
#include <igraphbt.hpp>
#include <icheckbx.hpp>
#include <icombobx.hpp>
#include <istring.hpp>
#include <istattxt.hpp>
#include <imsgbox.hpp>
#include <imcelcv.hpp>
#include <iselhdr.hpp>

#ifdef IC_MOTIF
#include <ipicvhdr.hpp>
#include <istring.hpp>
#endif

class AccountPage;
class SkillPage;
class ProjectPage;
class TasksPage;

class AGraphicPushButton : public IGraphicPushButton
{
public:
  AGraphicPushButton( unsigned long windowId,
                       IWindow* parent,
                       IWindow* owner,
                       unsigned long iconid);

  ~AGraphicPushButton();
};

#ifndef IC_MOTIF
class PageButtonsSelectHandler : public ISelectHandler
{
public:

    PageButtonsSelectHandler( IMultiCellCanvas* parent );
    ~PageButtonsSelectHandler();
    Boolean
      selected( IControlEvent& event );

private:
    IMultiCellCanvas
     *theParentMulticell;
};
#endif

class PageCnrButtons : public ISetCanvas
{
public:

    PageCnrButtons( unsigned long windowId
                   ,IWindow* parent
                   ,IWindow* owner
                   ,Boolean noChangeButton= false );

    ~PageCnrButtons();

private:

IGraphicPushButton
  *addButton,
  *removeButton,
  *changeButton;

};

class PageButtons : public ISetCanvas
{
public:

    PageButtons( unsigned long windowId
                ,IMultiCellCanvas* parent
                ,IMultiCellCanvas* owner
                ,Boolean noQueryButton = false );

    ~PageButtons();

private:

AGraphicPushButton
  *queryButton,
  *saveButton,
  *undoButton,
  *helpButton;

#ifndef IC_MOTIF
ICheckBox
  *gridCheckBox;
PageButtonsSelectHandler
  selectHandler;
#endif
};

class PageScrollButtons : public ISetCanvas
{
public:

  PageScrollButtons( unsigned long windowId
                    ,IWindow* parent
                    ,IWindow* owner );

  ~PageScrollButtons();

PageScrollButtons&
    setDisplayText( const char* theStr );

private:

IStaticText
    weekEndingText;

IString
    dateText;

AGraphicPushButton
    prevButton,
    nextButton;

IString
    displayText;

};

/******************************************************************************
* Class PageCnrSelHandler - Page container select handler.                    *
******************************************************************************/
class PageCnrSelHandler : public ISelectHandler
{
   public:
/*------------------------ Constructors/Destructor ----------------------------
| Construct the object given a page.                                          |
-----------------------------------------------------------------------------*/
      PageCnrSelHandler( AccountPage* page );
      PageCnrSelHandler( SkillPage* page );
      PageCnrSelHandler( ProjectPage* page );
      PageCnrSelHandler( TasksPage* page );
     ~PageCnrSelHandler();

   protected:

/*----------------------------- Event Processing ------------------------------
| Handle and process events:                                                  |
|   selected            - Process select events.                              |
-----------------------------------------------------------------------------*/
      Boolean
         selected( IControlEvent& event );

   private:

      enum
         PageType { accountPage, skillPage, projectPage, taskPage };

      IMultiCellCanvas
        *pPage;

      PageType
        pageType;
};


class QueryRange : public IComboBox
{
public:

    QueryRange( unsigned long windowId
               ,IWindow* parent
               ,IWindow* owner
               ,unsigned long id);

    ~QueryRange();

inline IString
    getRange() { return text();} ;

inline QueryRange&
    setRange(const IString& r ) { setText(r); return *this;} ;

};

#ifdef IC_MOTIF
class LPictureVerifyHandler : public IPictureVerifyHandler
{
public:
// ---------------------- PUBLIC -------------------------------------
  LPictureVerifyHandler( IWindow* owner,
                         IString pictureString);
  IWindow* owner();

protected:

  Boolean invalidChange           ( IEditVerifyEvent& event );

private:
//--------------------------- PRIVATE ----------------------------------------
  IWindow* pOwner;
};

const IString TEST_ALPHA             = IString("*a");
const IString TEST_LETTER            = IString("1a");
const IString TEST_ALPHANUMERIC      = IString("*&");
const IString TEST_DATE              = IString("1-2n '/' 1-2n '/' 2n");
const IString TEST_PHONE             = IString( "3n '-' 3n '-' 4n");
const IString TEST_FULL_NAME         = IString("*a 1w *a" );
const IString TEST_CURRENCY          = IString("*n 0-1p 0-2n");

#endif
#endif
