/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

/*-------------------------------------------------------------*\
|                                                               |
| letterdq.CPP  -  Letter Double Ended Queue                    |
|                  This is an example of using a Deque.         |
|                                                """""          |
\*-------------------------------------------------------------*/

#include <iostream.h>

#include <idqu.h>
                     // Let's use the default deque
typedef IDeque <char> Deque;
                     // The deque requires iteration to be const
typedef IConstantApplicator <char> CharApplicator;

class Print : public CharApplicator
{
public:
   IBoolean applyTo(char const&c)
      {
      cout << c;
      return True;
      }
};

/*-------------------------------------------------------------*\
| Test variables                                                |
\*-------------------------------------------------------------*/

char *String = "Teqikbonfxjmsoe  aydg.o zlarv pu o wr cu h";


/*-------------------------------------------------------------*\
| Main program                                                  |
\*-------------------------------------------------------------*/
int main()
{
   Deque D;
   char  C;
   IBoolean ReadFront = True;

   int i;

   // Put all characters in the deque.
   // Then read it, changing the end to read from
   // with every character read.

   cout << endl
        << "Adding characters to the back end of the deque:" << endl;

   for (i = 0; String[i] != 0; i ++) {
      D.addAsLast(String[i]);
      cout << String[i];
      }

   cout << endl << endl
        << "Current number of elements in the deque: "
        <<  D.numberOfElements() << endl;

   cout << endl
        << "Contents of the deque:" << endl;
   Print Aprinter;
   D.allElementsDo(Aprinter);

   cout << endl << endl
        << "Reading from the deque one element from front, one "
        << "from back, and so on:" << endl;

   while (!D.isEmpty())
      {
      if (ReadFront)                  // Read from front of Deque
         {
         C = D.firstElement();        // Get the character
         D.removeFirst();             // Delete it from the Deque
         }
      else
         {
         C = D.lastElement();
         D.removeLast();
         }
      cout << C;

      ReadFront = !ReadFront;     // Switch to other end of Deque
      }

   cout << endl;

   return(0);
}

