/******************************************************************************
* .FILE:         magnify.hpp                                                  *
*                                                                             *
* .DESCRIPTION:  Magnify Sample Program:  Class Header                        *
*                                                                             *
* .CLASSES:      MagnifyWindow                                                *
*                MagnifyHandler                                               *
*                                                                             *
* .COPYRIGHT:                                                                 *
*    Licensed Material - Program-Property of IBM                              *
*    (C) Copyright IBM Corp. 1992, 1996 - All Rights Reserved                 *
*                                                                             *
* .DISCLAIMER:                                                                *
*   The following [enclosed] code is sample code created by IBM               *
*   Corporation.  This sample code is not part of any standard IBM product    *
*   and is provided to you solely for the purpose of assisting you in the     *
*   development of your applications.  The code is provided 'AS IS',          *
*   without warranty of any kind.  IBM shall not be liable for any damages    *
*   arising out of your use of the sample code, even if they have been        *
*   advised of the possibility of such damages.                               *
*                                                                             *
* .NOTE: WE RECOMMEND USING A FIXED SPACE FONT TO LOOK AT THE SOURCE          *
*                                                                             *
******************************************************************************/
#ifndef _MAGNIFY_
#define _MAGNIFY_

#include <iapp.hpp>
#include <iframe.hpp>
#include <icmdhdr.hpp>
#include <igbitmap.hpp>
#include <igrafctx.hpp>
#include <ibmpctl.hpp>
#include <itimer.hpp>
#include <isetcv.hpp>
#include <icustbut.hpp>
#include <ispinnum.hpp>
#include <ititle.hpp>

#include "magnify.h"

class MagnifyHandler : public ICommandHandler
{
/*----------------------------------------------------------------------------|
| command - An overloaded function that handles command events                |
-----------------------------------------------------------------------------*/
protected:
  Boolean command (ICommandEvent& event);
};

class MagnifyWindow : public IFrameWindow
{
public:
/*------------------------------- Constructor --------------------------------|
| Constructs the object with:                                                 |
| 1) No parameters                                                            |
-----------------------------------------------------------------------------*/
  MagnifyWindow      ();

/*----------------------------------------------------------------------------|
| timerFunction - A function that is called after the timer expiring          |
-----------------------------------------------------------------------------*/
  void timerFunction ();


private:
  IBitmapControl
    bitmapControl;
  ISetCanvas
    canvas;
  IStaticText
    xText;
  INumericSpinButton
    xSpin;
  IStaticText
    yText;
  INumericSpinButton
    ySpin;
  MagnifyHandler
    handler;
  IGBitmap
   *bitmap;
  ITitle
    title;
public:
  ICustomButton
    button;
  ITimer
    timer;

};

#endif /* _MAGNIFY_ */
