/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

/*-------------------------------------------------------------*\
|  planet.h  -  Class Planet for use in our Sorted Set example  |
\*-------------------------------------------------------------*/
#include <iostream.h>
#include <iappl.h>

class Planet   {
 private:
   char* plname;
   float dist;
   float mass;
   float bright;

 public:
     // Let's use the compiler generated default for
     // the copy constructor

   Planet(char* aname, float adist, float amass, float abright) :
     plname(aname), dist(adist),  mass(amass), bright(abright) {}

     // For any Set we need to provide element equality.
   IBoolean operator== (Planet const& aPlanet) const
      { return plname == aPlanet.plname; }

     // For a Sorted Set we need to provide element comparision.
   IBoolean operator< (Planet const& aPlanet) const
      { return dist < aPlanet.dist; }

   char*   name()     { return  plname; }

   IBoolean isHeavy()  { return (mass   > 1.0); }
   IBoolean isBright() { return (bright < 0.0); }
};


/*-------------------------------------------------------------*\
|   Applicator                                                  |
\*-------------------------------------------------------------*/

class SayPlanetName : public IApplicator<Planet>   {
 public:
   virtual IBoolean applyTo(Planet& p)
         { cout << " " << p.name() << " "; return True;}
};

