/******************************************************************************
* .FILE:         asetcv.cpp                                                   *
*                                                                             *
* .DESCRIPTION:  Set Canvas Example:  Class Implementation                    *
*                                                                             *
* .CLASSES:      ASetCanvas                                                   *
*                AButtonHandler                                               *
*                                                                             *
* .COPYRIGHT:                                                                 *
*    Licensed Material - Program-Property of IBM                              *
*    (C) Copyright IBM Corp. 1992, 1996 - All Rights Reserved                 *
*                                                                             *
* .DISCLAIMER:                                                                *
*   The following [enclosed] code is sample code created by IBM               *
*   Corporation.  This sample code is not part of any standard IBM product    *
*   and is provided to you solely for the purpose of assisting you in the     *
*   development of your applications.  The code is provided 'AS IS',          *
*   without warranty of any kind.  IBM shall not be liable for any damages    *
*   arising out of your use of the sample code, even if they have been        *
*   advised of the possibility of such damages.                               *
*                                                                             *
* .NOTE: WE RECOMMEND USING A FIXED SPACE FONT TO LOOK AT THE SOURCE          *
*                                                                             *
******************************************************************************/
#include <ibase.hpp>
#include <iapp.hpp>
#include <ipoint.hpp>
#include <istring.hpp>
#include <icoordsy.hpp>
#include "asetcv.h"
#include "asetcv.hpp"

/******************************************************************************
* main  - Application entry point                                             *
******************************************************************************/
int main()
{
  ICoordinateSystem::setApplicationOrientation(
          ICoordinateSystem::originLowerLeft );
  ASetCanvas mainWindow(WND_MAIN);
  IApplication::current().run();
  return 0;
} /* end main */

/******************************************************************************
* ASetCanvas :: ASetCanvas - Constructor for our main window                  *
******************************************************************************/
ASetCanvas::ASetCanvas(unsigned long windowId)
  : IFrameWindow( windowId )
  , clientCanvas( WND_SPLITCANVAS, this, this, IRectangle(),
                  ISplitCanvas::horizontal | IWindow::visible )
  , status( WND_STATUS, &clientCanvas, &clientCanvas )
  , vSetCanvas( WND_VSETCANVAS, &clientCanvas, &clientCanvas )
  , hSetCanvas( WND_HSETCANVAS, &clientCanvas, &clientCanvas )
  , buttonHandler(&status)
{
/*-----------------------------------------------------------------------------|
|  Set the icon for the main window and make the split canvas the client areas |
------------------------------------------------------------------------------*/
  setIcon( id() );
  setClient( &clientCanvas );

/*-----------------------------------------------------------------------------|
|  Set the alignment of the static text in the status area to the center       |                                                                            |
------------------------------------------------------------------------------*/
  status.setAlignment( IStaticText::centerCenter );

/*-----------------------------------------------------------------------------|
|  Set the top canvas so that it has 3 vertical decks                          |
------------------------------------------------------------------------------*/
  vSetCanvas.setDeckOrientation( ISetCanvas::vertical );
  vSetCanvas.setDeckCount( 3 );

/*-----------------------------------------------------------------------------|
| Set the bottom canvas so that it has 3 horizontal decks                      |
------------------------------------------------------------------------------*/
  hSetCanvas.setDeckOrientation( ISetCanvas::horizontal );
  hSetCanvas.setDeckCount( 3 );
  hSetCanvas.setPad(ISize(10,10));

/*-----------------------------------------------------------------------------|
|  Give the button handler the static text string.                             |
------------------------------------------------------------------------------*/
  unsigned int i, mid = (NUMBER_OF_BUTTONS/2);

/*-----------------------------------------------------------------------------|
|  Creates the first set of radio buttons, add the button to the handler,      |
|    and sets the text of the radio button                                     |
|  Sets the first button to the tabStop and Group Styles.                      |
|  Selects the first button in the group.                                      |
------------------------------------------------------------------------------*/
  for (i = 0 ; i < mid ; ++i)
  {
    radiobut[i] = new IRadioButton( WND_BUTTON + i, &vSetCanvas, &vSetCanvas );
    buttonHandler.handleEventsFor( radiobut[i] );
    radiobut[i]->setText( STR_TEXT + i );
  }
  radiobut[0]->enableGroup().enableTabStop();
  radiobut[0]->select();

/*-----------------------------------------------------------------------------|
|  Creates the second set of radio buttons, add the button to the handler,     |
|    and sets the text of the radio button                                     |
|  Sets the mid button to the tabStop and Group Styles.                        |
|  Selects the first button in this group.                                     |
------------------------------------------------------------------------------*/
  for (i = mid ; i < NUMBER_OF_BUTTONS ; ++i)
  {
    radiobut[i] = new IRadioButton( WND_BUTTON + i, &hSetCanvas, &hSetCanvas );
    buttonHandler.handleEventsFor( radiobut[i] );
    radiobut[i]->setText( STR_TEXT + i );
  }
  radiobut[mid]->enableGroup().enableTabStop();
  radiobut[mid]->select();

/*-----------------------------------------------------------------------------|
| Sets focus to the first button and sets the status string to text from       |
|   resource file.                                                             |
------------------------------------------------------------------------------*/
  radiobut[0]->setFocus();
  status.setText( STR_STATUS );

  show();

} /* end ASetCanvas :: ASetCanvas(...) */

/******************************************************************************
* ASetCanvas ::~ASetCanvas - Destructor for our main window                   *
******************************************************************************/
ASetCanvas::~ASetCanvas()
{
  for (unsigned int i = 0; i < NUMBER_OF_BUTTONS ; ++i)
  {
    delete radiobut[i];
  }
}

/******************************************************************************
* Class AButtonHandler::selected - displays the number of the button selected *
*   in the status area.                                                       *
******************************************************************************/

IBase::Boolean AButtonHandler::selected(IControlEvent& evt )
{
  Boolean
    fHandled = true;

  unsigned long
    ulButtonId = evt.controlId();

/*----------------------------------------------------------------------------|
|  If the id of the event is one of the buttons, then display the button      |
|  number in the static text control                                          |
-----------------------------------------------------------------------------*/
  if ( ulButtonId >= WND_BUTTON &&
       ulButtonId <= (WND_BUTTON+NUMBER_OF_BUTTONS) &&
       output)
    output->setText( IString( ulButtonId-WND_BUTTON+1 ) );
  else
     fHandled = false;                 // pass event to other handlers

  return fHandled;

} /* end AButtonHandler::selected(...) */
