/******************************************************************************
* .FILE:         asetcv.hpp                                                   *
*                                                                             *
* .DESCRIPTION:  Set Canvas Example:  Class Headers                           *
*                                                                             *
* .CLASSES:      AButtonHandler                                               *
*                ASetCanvas                                                   *
*                                                                             *
* .COPYRIGHT:                                                                 *
*    Licensed Material - Program-Property of IBM                              *
*    (C) Copyright IBM Corp. 1992, 1996 - All Rights Reserved                 *
*                                                                             *
* .DISCLAIMER:                                                                *
*   The following [enclosed] code is sample code created by IBM               *
*   Corporation.  This sample code is not part of any standard IBM product    *
*   and is provided to you solely for the purpose of assisting you in the     *
*   development of your applications.  The code is provided 'AS IS',          *
*   without warranty of any kind.  IBM shall not be liable for any damages    *
*   arising out of your use of the sample code, even if they have been        *
*   advised of the possibility of such damages.                               *
*                                                                             *
* .NOTE: WE RECOMMEND USING A FIXED SPACE FONT TO LOOK AT THE SOURCE          *
*                                                                             *
******************************************************************************/
#ifndef ASETCV_HPP
#define ASETCV_HPP

#include <iframe.hpp>                   // IFrameWindow
#include <istattxt.hpp>                 // IStaticText
#include <iradiobt.hpp>                 // IRadioButton
#include <isetcv.hpp>                   // ISetCanvas
#include <isplitcv.hpp>                 // ISplitCanvas
#include <iselhdr.hpp>                  // ISelectHandler

/******************************************************************************
* Class AButtonHandler - Select handler to handle radio buttons               *                                                                          *
******************************************************************************/
class AButtonHandler : public ISelectHandler
{
  public:
/*------------------------------ Constructor ---------------------------------|
| Constructs the object with:                                                 |
| 1) a pointer to the static text string of the status area                   |
-----------------------------------------------------------------------------*/
    AButtonHandler(IStaticText * pstatus) : output(pstatus) {}

  protected:
/*--------------------------- Overloaded Functions ---------------------------|
| selected -- handles selections of the radio buttons                         |
-----------------------------------------------------------------------------*/
    virtual Boolean
      selected( IControlEvent& evt );

  private:
    IStaticText
     *output;
};

/******************************************************************************
* Class ASetCanvas -- Main window for set canvas sample                       *
******************************************************************************/
class ASetCanvas : public IFrameWindow
{
  public:
/*------------------------------ Constructor ---------------------------------|
| Constructs the object with:                                                 |
| 1) the window id                                                            |
-----------------------------------------------------------------------------*/
    ASetCanvas(unsigned long windowId);

/*------------------------------- Destructor ---------------------------------|
| Destructs the object with:                                                  |
| 1) No Parameters                                                            |
-----------------------------------------------------------------------------*/
   ~ASetCanvas();

  private:
    ISplitCanvas
      clientCanvas;
    IStaticText
      status;
    ISetCanvas
      vSetCanvas,
      hSetCanvas;
    IRadioButton
     *radiobut[NUMBER_OF_BUTTONS];
    AButtonHandler
      buttonHandler;
};

#endif
