/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

/*-------------------------------------------------------------*\
|  sumup.CPP  - Sum up integers to demonstrate using iterators. |
|                                                    """""""""  |
|  Add all elements in a bag to demonstrate the use of          |
|  iterators with additional arguments.                         |
|  The bag elements are integers passed as arguments to main(). |
\*-------------------------------------------------------------*/

   #include <ibag.h>
   #include <iostream.h>
   #include <stdlib.h>

   typedef IBag <int> IntBag;

   class SumApplicator : public IConstantApplicator <int> {
     int ivSum;
   public:
     SumApplicator () : ivSum (0) {}
     IBoolean applyTo (int const& i) {
       ivSum += i;
       return True;
     }
     int sum () { return ivSum; }
   };


   int sumUsingApplicatorObject (IntBag const& bag) {
     SumApplicator sumUp;
     bag.allElementsDo (sumUp);
     return sumUp.sum ();
   }


   IBoolean sumUpFunction (int const& i, void* sum) {
     *(int*)sum += i;
     return True;
   };

   int sumUsingApplicatorFunction (IntBag const& bag) {
     int sum = 0;
     bag.allElementsDo (sumUpFunction, &sum);
     return sum;
   }


int main (int argc, char* argv[])  {
     IntBag intbag;
     for (int cnt=1; cnt < argc; cnt++)
        intbag.add(atoi(argv[cnt]));

     cout << "Sum obtained using an Applicator Object = "
          <<  sumUsingApplicatorObject(intbag)  << endl;

     cout << "Sum obtained using an Applicator Function = "
          <<  sumUsingApplicatorFunction(intbag)  << endl;

     return 0;
     }
