/******************************************************************************
* .FILE:         tbar1.hpp                                                    *
*                                                                             *
* .DESCRIPTION:  Tool Bar Example 1:  Class Implementation                    *
*                                                                             *
* .CLASSES:      FontSelectHandler                                            *
*                ACommandHandler                                              *
*                Editor                                                       *
*                                                                             *
* .COPYRIGHT:                                                                 *
*    Licensed Material - Program-Property of IBM                              *
*    (C) Copyright IBM Corp. 1992, 1996 - All Rights Reserved                 *
*                                                                             *
* .DISCLAIMER:                                                                *
*   The following [enclosed] code is sample code created by IBM               *
*   Corporation.  This sample code is not part of any standard IBM product    *
*   and is provided to you solely for the purpose of assisting you in the     *
*   development of your applications.  The code is provided 'AS IS',          *
*   without warranty of any kind.  IBM shall not be liable for any damages    *
*   arising out of your use of the sample code, even if they have been        *
*   advised of the possibility of such damages.                               *
*                                                                             *
* .NOTE: WE RECOMMEND USING A FIXED SPACE FONT TO LOOK AT THE SOURCE          *
*                                                                             *
******************************************************************************/
#include <ibase.hpp>
#include <iapp.hpp>
#include <iframe.hpp>
#include <ifont.hpp>
#include <itbar.hpp>
#include <itbarbut.hpp>
#include <imle.hpp>
#include <icmdhdr.hpp>
#include <imenubar.hpp>
#include <iflytext.hpp>
#include <istattxt.hpp>
#include <iflyhhdr.hpp>
#include <icombobx.hpp>
#include <iselhdr.hpp>
#include <icoordsy.hpp>
#include "tbar1.hpp"
#include "tbar1.h"

/******************************************************************************
* main - Application entry point                                              *
******************************************************************************/
int main()
{
  ICoordinateSystem::setApplicationOrientation(
          ICoordinateSystem::originLowerLeft );
   Editor editor;
   editor.show();
   editor.setFocus();
   IApplication::current().run();
   return 0;
}

/******************************************************************************
* class Editor::Editor - Constructor for main windows                         *
*                                                                             *
* Initialize the main window.                                                 *
* Initialize the title bar                                                    *
* Initialize the fly over help and text                                       *
* Initialize the multi line editor                                            *
* Initialize the toolbar and all of the controls associated with the toolbar  *
* Initialize the menu                                                         *
* Initialize the fontSelectHandler and the command Handler                    *
******************************************************************************/

Editor::Editor ()
       :IFrameWindow(ID_MAIN_WINDOW),
        title(this),
        flyText(ID_FLYTEXT, &toolBar),
        infoText(ID_INFOTEXT, this, this),
        flyHelpHandler(&flyText, &infoText, 0, 0),
        editWindow(ID_EDITOR, this, this),
        toolBar(ID_TOOLBAR, this),
        cutButton       (IC_ID_CUT,        &toolBar, &toolBar),
        copyButton      (IC_ID_COPY,       &toolBar, &toolBar),
        pasteButton     (IC_ID_PASTE,      &toolBar, &toolBar),
        boldButton      (IC_ID_BOLD,       &toolBar, &toolBar),
        italicButton    (IC_ID_ITALIC,     &toolBar, &toolBar),
        underscoreButton(IC_ID_UNDERSCORE, &toolBar, &toolBar),
        fontCombo(ID_FONTCOMBO, &toolBar, &toolBar, IRectangle(),
                  IComboBox::classDefaultStyle |
                  IComboBox::simpleType |
                  IComboBox::readOnlyDropDownType),
        menu(ID_MAIN_WINDOW,this),
        fontSelectHandler(*this),
        editFont(),
        commandhandler(&editFont,&toolBar,&editWindow)
{
/*----------------------------------------------------------------------------|
| Set the icon and title text                                                 |
-----------------------------------------------------------------------------*/
   setIcon( id() );
   title.setTitleText(ID_MAIN_WINDOW);


/*----------------------------------------------------------------------------|
| Add the buttons to the toolbar                                              |
-----------------------------------------------------------------------------*/
   toolBar.addAsLast(&cutButton,true);
   toolBar.addAsLast(&copyButton);
   toolBar.addAsLast(&pasteButton);
   toolBar.addAsLast(&boldButton,true);
   toolBar.addAsLast(&italicButton);
   toolBar.addAsLast(&underscoreButton);
   toolBar.addAsLast(&fontCombo,true);

/*----------------------------------------------------------------------------|
| Set up latchable style for font property buttons                            |
-----------------------------------------------------------------------------*/
   boldButton.enableLatching();
   italicButton.enableLatching();
   underscoreButton.enableLatching();

/*----------------------------------------------------------------------------|
| Load up font combo box with face names                                      |
-----------------------------------------------------------------------------*/
   fontCombo.setLimit(10);
   IFont::FaceNameCursor fontCursor;
   for ( fontCursor.setToFirst(); fontCursor.isValid(); fontCursor.setToNext())
   {
     IString faceName = IFont::faceNameAt(fontCursor);
     fontCombo.addAsLast(faceName);
     if (faceName.length() > fontCombo.limit())
       fontCombo.setLimit(faceName.length());
   }

/*----------------------------------------------------------------------------|
| Set up title for toolbar when floating                                      |
-----------------------------------------------------------------------------*/
   toolBar.setFloatingTitle(STR_TOOLBAR);

/*----------------------------------------------------------------------------|
| Setup the editor                                                            |
-----------------------------------------------------------------------------*/
   setClient(&editWindow);
   editWindow.setFont(editFont);
   editWindow.importFromFile("toolbar.not");
   editWindow.setTop(1);

/*----------------------------------------------------------------------------|
| Add the info frame extension                                                |
-----------------------------------------------------------------------------*/
   addExtension(&infoText, IFrameWindow::belowClient);

/*----------------------------------------------------------------------------|
| Set up and add the help handler                                             |
-----------------------------------------------------------------------------*/
   flyHelpHandler.setLongStringTableOffset(OFFSET_INFOTEXT);
   flyHelpHandler.handleEventsFor(&toolBar);

/*----------------------------------------------------------------------------|
| Attach the Command Handler to the frame and toolbar                         |
-----------------------------------------------------------------------------*/
   commandhandler.handleEventsFor(this);
   commandhandler.handleEventsFor(&toolBar);

/*----------------------------------------------------------------------------|
| Allow the font select handler to handle events for font combo box.          |
-----------------------------------------------------------------------------*/
   fontSelectHandler.handleEventsFor(&fontCombo);

   moveSizeToClient(IRectangle(IPoint(100,100),
                               ISize(editFont.avgCharWidth()*80,
                                     editFont.maxCharHeight()*15)));
}


/******************************************************************************
* class ACommandHandler::command - Handles menu bar selections and toolbar    *
*   selections.                                                               *
******************************************************************************/
IBase::Boolean ACommandHandler::command(ICommandEvent &event)
{
   switch (event.commandId())
   {
     case IC_ID_CUT:
     {
         if(editWindow->hasSelectedText())
            editWindow->cut();
         break;
     }
     case IC_ID_COPY:
     {
         if(editWindow->hasSelectedText())
            editWindow->copy();
         break;
     }
     case IC_ID_PASTE:
     {
         if(editWindow->clipboardHasTextFormat())
            editWindow->paste();
         break;
     }
     case IC_ID_BOLD:
     {
         bold=!bold;
         editFont->setBold(bold/*Button.isLatched()*/);
         editWindow->setFont(*editFont);
         break;
     }
     case IC_ID_ITALIC:
     {
         italic=!italic;
         editFont->setItalic(italic/*Button.isLatched()*/);
         editWindow->setFont(*editFont);
         break;
     }
     case IC_ID_UNDERSCORE:
     {
         under=!under;
         editFont->setUnderscore(under/*scoreButton.isLatched()*/);
         editWindow->setFont(*editFont);
         break;
     }
     case ID_SHOWTEXT:
     {
         toolBar->setButtonView(IToolBarButton::textView);
         break;
     }
     case ID_SHOWBITMAPS:
     {
         toolBar->setButtonView(IToolBarButton::bitmapView);
         break;
     }
     case ID_SHOWTEXTANDBITMAPS:
     {
         toolBar->setButtonView(IToolBarButton::bitmapAndTextView);
         break;
     }
     case ID_TOOLBAR_TOP:
     {
         toolBar->setLocation(IToolBar::aboveClient);
         break;
     }
     case ID_TOOLBAR_BOTTOM:
     {
         toolBar->setLocation(IToolBar::belowClient);
         break;
     }
     case ID_TOOLBAR_LEFT:
     {
         toolBar->setLocation(IToolBar::leftOfClient);
         break;
     }
     case ID_TOOLBAR_RIGHT:
     {
         toolBar->setLocation(IToolBar::rightOfClient);
         break;
     }
     case ID_TOOLBAR_FLOATING:
     {
         toolBar->setLocation(IToolBar::floating);
         break;
     }
   }
   return true;
}

/******************************************************************************
* class FontSelectHandler::enter - Handle combo box selections
******************************************************************************/
IBase::Boolean FontSelectHandler::enter( IControlEvent& event)
{
  IString fontChoice =  ((IComboBox*)event.controlWindow())->text();
  if(fontChoice.length())
  {
/*----------------------------------------------------------------------------|
| Set the new font                                                            |
-----------------------------------------------------------------------------*/
     editorFrame.editorFont().setName(fontChoice);
     editorFrame.editorWindow().setFont(editorFrame.editorFont());
  }
  return true;
}

