/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

/*-------------------------------------------------------------*\
|  transelm.h  -  Class TranslationElement  for use with the    |
|                 Translation Table example.                    |
\*-------------------------------------------------------------*/
#ifndef _TRANSELM_H
#define _TRANSELM_H

#include <iglobals.h>

class TranslationElement  {

  char ivAscCode;
  char ivEbcCode;

public:

  /* Let the compiler generate Default and Copy Constructor,*/
  /* Destructor and Assignment for us.                      */

  char const& ascCode () const
       { return ivAscCode;
       }

  char const& ebcCode () const
       { return ivEbcCode;
       }

  TranslationElement (char asc, char ebc)
       : ivAscCode(asc), ivEbcCode(ebc) {};

  /* We need to define the equality.                        */
  IBoolean operator == (TranslationElement const& te) const  {
     return ivAscCode == te.ivAscCode
        &&  ivEbcCode == te.ivEbcCode;
   };

  /* An ordering relation must not be defined for           */
  /* elements in a map.                                     */

  /* We need to define the key access for the elements.     */
  /* We decided to define all key operations in a           */
  /* separate operations class in file trmapops.h.          */

};

#endif
