/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

/*-------------------------------------------------------------*\
|  trmapops.h  -  Translation Map Operations                    |
|                 This is the base class for the element        |
|                 operations for our Translation Map example.   |
\*-------------------------------------------------------------*/
#ifndef _TRMAPOPS_H
#define _TRMAPOPS_H

       /* Get the standard operation classes.                  */
#include <istdops.h>

#include "transelm.h"

class TranslationOps : public IEOps < TranslationElement >
{
public:
  class KeyOps : public IStdEqOps < char >, public IStdHshOps < char >
  {
  }  keyOps;
};

       /* Operations Class for the EBCDIC-ASCII mapping:       */
class TranslationOpsE2A : public TranslationOps
{
public:                     /* Key Access                      */
  char const& key (TranslationElement const& te) const
    { return te.ebcCode (); }
};


       /* Operations Class for the ASCII-EBCDIC mapping:       */
class TranslationOpsA2E : public TranslationOps
{
public:                     /* Key Access                      */
  char const& key (TranslationElement const& te) const
    { return te.ascCode (); }
};

#endif
