/******************************************************************************
* .FILE:         version.h                                                    *
*                                                                             *
* .DESCRIPTION:  Version Sample Application:   Implementation                 *
*                                                                             *
* .CLASSES:                                                                   *
*                                                                             *
* .COPYRIGHT:                                                                 *
*    Licensed Material - Program-Property of IBM                              *
*    (C) Copyright IBM Corp. 1992, 1996 - All Rights Reserved                 *
*                                                                             *
* .DISCLAIMER:                                                                *
*   The following [enclosed] code is sample code created by IBM               *
*   Corporation.  This sample code is not part of any standard IBM product    *
*   and is provided to you solely for the purpose of assisting you in the     *
*   development of your applications.  The code is provided 'AS IS',          *
*   without warranty of any kind.  IBM shall not be liable for any damages    *
*   arising out of your use of the sample code, even if they have been        *
*   advised of the possibility of such damages.                               *
*                                                                             *
* .NOTE: WE RECOMMEND USING A FIXED SPACE FONT TO LOOK AT THE SOURCE          *
*                                                                             *
******************************************************************************/
#include <ibase.hpp>
#include <iapp.hpp>
#include <ititle.hpp>
#include <istring.hpp>
#include <istattxt.hpp>
#include <iframe.hpp>
#include <ireslib.hpp>
#include <icoordsy.hpp>
#include "version.h"

int main()
{
  ICoordinateSystem::setApplicationOrientation(
          ICoordinateSystem::originLowerLeft );

  IResourceLibrary
    reslib;

/*----------------------------------------------------------------------------|
| Create the main window with a window id of 0x1000                           |
-----------------------------------------------------------------------------*/
  IFrameWindow mainWindow (WND_MAIN);

/*----------------------------------------------------------------------------|
| Create a title for the main window                                          |
| Set the title text with a string from the resource file                     |
-----------------------------------------------------------------------------*/
  ITitle mainTitle(&mainWindow);
  mainTitle.setTitleText(reslib.loadString(WND_MAIN));

/*----------------------------------------------------------------------------|
| Place a static text string in the main window.                              |
| Set the static text string with the version information.                    |                                                        |
| Set the alignment of the text to the center of the window.                  |
| Set the static text as the client of the main window                        |
-----------------------------------------------------------------------------*/
  IStaticText version(WND_TEXT, &mainWindow, &mainWindow);

  version.setText(reslib.loadString(STR_MAJOR)+
                  IString(IC_MAJOR_VERSION)+
                  reslib.loadString(STR_SPACES)+reslib.loadString(STR_MINOR)+
                  IString(IC_MINOR_VERSION));
  version.setAlignment(IStaticText::centerCenter);
  mainWindow.setClient(&version);

/*----------------------------------------------------------------------------|
| Set the size of the main window, change the focus to the main window, and   |
|   show the main window.                                                     |
| Run the application.                                                        |
-----------------------------------------------------------------------------*/
  mainWindow.sizeTo(ISize(800,100));
  mainWindow.setFocus();
  mainWindow.show();
  IApplication::current().run();
  return 0;
} /* end main */
