/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

/*-------------------------------------------------------------*\
|  toyword.h  -  Class Word for use with coding examples.       |
\*-------------------------------------------------------------*/

#include <istring.hpp>

class Word  {

  IString      ivWord;
  unsigned int ivKey;

public:

  //Constructor to be used for sample: wordbag.c
  Word (IString const& word, unsigned theLength)
  : ivWord (word), ivKey (theLength) {}

  //Constructor to be used for sample: wordseq.c
  Word (IString const& word)
  : ivWord (word) {}

  IBoolean operator> (Word const& w1)
           { return ivWord > w1.ivWord;
           }

  unsigned int setKey ()
            { return (ivKey = ivWord.length());
            }

  IString const& getWord() const
            { return ivWord;
            }

  unsigned int const& getKey() const
            { return ivKey;
            }
};

// Key access.  The length of the word is the key.
inline unsigned int const& key (Word const& aWord)
{ return aWord.getKey();
}
