/**********************************************************************
*                                                                     *
*  IBM(R) VisualAge(TM) for C++ for Windows(R), Version 3.5           *
*                                                                     *
*  PID: 5622-880                                                      *
*  - Licensed Material - Program-Property of IBM                      *
*  (C) Copyright IBM Corp. 1991, 1995 - All Right Reserved.           *
*                                                                     *
*  US Government Users Restricted Rights - Use, duplication or        *
*  disclosure restricted by GSA ADP Schedule Contract with IBM Corp.  *
*                                                                     *
*  VisualAge, and IBM are trademarks or registered trademarks of      *
*  International Business Machines Corporation.                       *
*  Windows is a registered trademark of Microsoft Corporation.        *
*                                                                     *
**********************************************************************/

/*---------------------------------------------------------------*\
|  wordbag.CPP  -  Word Bag, example for the use of the           |
|                  Key Sorted Bag to perform statistics on words. |
|                  """"""""""""""                                 |
|  The elements handled in the collections are the words of a     |
|  phrase. The key of each word is the number of its letters.     |
|  The Key Sorted Bag will store all occurences of each key.      |
|  We use this to calculate the number of n-letter words in       |
|  the phrase.                                                    |
|                                                                 |
\*---------------------------------------------------------------*/

   #include <iostream.h>
                                // Class Word
   #include "toyword.h"
                                // Let's use the defaults:
   #include <iksb.h>

   typedef IKeySortedBag <Word, unsigned> WordBag;


int main()
{
   IString    phrase[10] = {"people", "who", "live", "in", "glass",
                   "houses", "should", "not", "throw", "stones"};
   const size_t phraseWords = sizeof(phrase) / sizeof(IString);

   WordBag wordbag(phraseWords);

   for (int cnt=0; cnt < phraseWords; cnt++)  {
    unsigned keyValue = phrase[cnt].length();
    Word theWord(phrase[cnt],keyValue);
    wordbag.add (theWord);
   }

   cout << "Contents of our WordBag sorted by number of letters:"
        << endl;

   WordBag::Cursor wordBagCursor(wordbag);
   forICursor(wordBagCursor)
     cout << "WB: " << wordBagCursor.element().getWord() << endl;

   cout << endl << "Our phrase has " << phraseWords << " words."
        << endl;

   cout << "In our WordBag are " << wordbag.numberOfElements()
        << " words." << endl << endl;

   cout << "There are " << wordbag.numberOfDifferentKeys()
        << " different word lengths." << endl << endl;

   wordBagCursor.setToFirst();
   do  {
      unsigned letters = wordbag.key(wordBagCursor.element());
      cout << "There are "
           << wordbag.numberOfElementsWithKey(letters)
           << " words with " << letters << " letters." << endl;
   }  while  (wordbag.setToNextWithDifferentKey(wordBagCursor));

   return 0;
}
